% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/raw.R
\name{raw_deparse_str}
\alias{raw_deparse_str}
\title{Serialize a raw vector to a string}
\usage{
raw_deparse_str(x, prefix = NULL, suffix = NULL)
}
\arguments{
\item{x}{A raw vector.}

\item{prefix, suffix}{Prefix and suffix strings, or `NULL.}
}
\value{
A string.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

This function converts a raw vector to a hexadecimal string,
optionally adding a prefix and a suffix.
It is roughly equivalent to
\code{paste0(prefix, paste(format(x), collapse = ""), suffix)}
and much faster.
}
\examples{
raw_deparse_str(raw())
raw_deparse_str(charToRaw("string"))
raw_deparse_str(raw(10), prefix = "'0x", suffix = "'")
}
\keyword{internal}
