% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/graph_embed.R
\docType{class}
\name{DrL-class}
\alias{DrL-class}
\alias{DrL}
\title{Distributed Recursive Graph Layout}
\description{
An S4 Class implementing Distributed recursive Graph Layout.
}
\details{
DrL uses a complex algorithm to avoid local minima in the graph
embedding which uses several steps.
}
\section{Slots}{

\describe{
\item{\code{fun}}{A function that does the embedding and returns a
dimRedResult object.}

\item{\code{stdpars}}{The standard parameters for the function.}
}}

\section{General usage}{

Dimensionality reduction methods are S4 Classes that either be used
directly, in which case they have to be initialized and a full
list with parameters has to be handed to the \code{@fun()}
slot, or the method name be passed to the embed function and
parameters can be given to the \code{...}, in which case
missing parameters will be replaced by the ones in the
\code{@stdpars}.
}

\section{Parameters}{

DrL can take the following parameters:
\describe{
  \item{ndim}{The number of dimensions, defaults to 2. Can only be 2 or 3}
  \item{knn}{Reduce the graph to keep only the neares neighbors. Defaults to 100.}
  \item{d}{The distance function to determine the weights of the graph edges. Defaults to euclidean distances.}
}
}

\section{Implementation}{

Wraps around \code{\link[igraph]{layout_with_drl}}. The parameters
maxiter, epsilon and kkconst are set to the default values and
cannot be set, this may change in a future release. The DimRed
Package adds an extra sparsity parameter by constructing a knn
graph which also may improve visualization quality.
}

\examples{
\dontrun{
if(requireNamespace(c("igraph", "coRanking"), quietly = TRUE)) {

dat <- loadDataSet("Swiss Roll", n = 200)
emb <- embed(dat, "DrL")
plot(emb, type = "2vars")
}

}

}
\references{
Martin, S., Brown, W.M., Wylie, B.N., 2007. Dr.l: Distributed Recursive
(graph) Layout (No. dRl; 002182MLTPL00). Sandia National Laboratories.
}
\seealso{
Other dimensionality reduction methods: 
\code{\link{DRR-class}},
\code{\link{DiffusionMaps-class}},
\code{\link{FastICA-class}},
\code{\link{FruchtermanReingold-class}},
\code{\link{HLLE-class}},
\code{\link{Isomap-class}},
\code{\link{KamadaKawai-class}},
\code{\link{MDS-class}},
\code{\link{NNMF-class}},
\code{\link{PCA-class}},
\code{\link{PCA_L1-class}},
\code{\link{UMAP-class}},
\code{\link{dimRedMethod-class}},
\code{\link{dimRedMethodList}()},
\code{\link{kPCA-class}},
\code{\link{nMDS-class}},
\code{\link{tSNE-class}}
}
\concept{dimensionality reduction methods}
