% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/restructure.R
\name{restructure}
\alias{restructure}
\title{Restructure Old R Objects}
\usage{
restructure(x, ...)
}
\arguments{
\item{x}{An object to be restructured. The object's class will determine
which method to apply}

\item{...}{Additional arguments to pass to the specific methods}
}
\value{
An object of the same class as \code{x} compatible with the latest
 version of the package that generated it.
}
\description{
\code{restructure} is a generic function used to restructure old R objects to
work with newer versions of the package that generated them. Its original
use is within the \pkg{brms} package, but new methods for use with objects
from other packages can be registered to the same generic.
}
\details{
Usually the version of the package that generated the object will be
  stored somewhere in the object and this information will be used by the
  specific method to determine what transformations to apply. See
  \code{\link[brms:restructure.brmsfit]{restructure.brmsfit}} for the default
  method applied for \pkg{brms} models. You can view the available methods by
  typing: \code{methods(restructure)}
}
\seealso{
\code{\link{restructure.brmsfit}}
}
