/*
 * Decompiled with CFR 0.152.
 */
package org.chefproject.actions;

import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import org.apache.jetspeed.portal.portlets.VelocityPortlet;
import org.apache.jetspeed.services.rundata.JetspeedRunData;
import org.apache.jetspeed.services.statemanager.SessionState;
import org.apache.turbine.util.Log;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;
import org.chefproject.actions.VelocityPortletPaneledAction;
import org.chefproject.core.RealmEdit;
import org.chefproject.core.Role;
import org.chefproject.core.RoleEdit;
import org.chefproject.core.User;
import org.chefproject.exception.IdInvalidException;
import org.chefproject.exception.IdUnusedException;
import org.chefproject.exception.IdUsedException;
import org.chefproject.exception.InUseException;
import org.chefproject.exception.PermissionException;
import org.chefproject.service.RealmService;
import org.chefproject.service.ServerConfigurationService;
import org.chefproject.service.UserDirectoryService;
import org.chefproject.util.EventObservingCourier;
import org.chefproject.util.Menu;
import org.chefproject.util.MenuEntry;
import org.chefproject.util.StringUtil;

public class RealmsAction
extends VelocityPortletPaneledAction {
    protected void initState(SessionState state, VelocityPortlet portlet, JetspeedRunData rundata) {
        super.initState(state, portlet, rundata);
        if (state.getAttribute("obsever") == null) {
            String deliveryId = this.clientWindowId(state, portlet.getID());
            String elementId = VelocityPortletPaneledAction.mainPanelUpdateId(portlet.getID());
            String pattern = RealmService.realmReference("");
            state.setAttribute("obsever", (Object)new EventObservingCourier(deliveryId, elementId, pattern));
        }
        this.updateObservationOfChannel(state, portlet.getID());
    }

    private void updateObservationOfChannel(SessionState state, String peid) {
        EventObservingCourier observer = (EventObservingCourier)state.getAttribute("obsever");
        String deliveryId = this.clientWindowId(state, peid);
        observer.setDeliveryId(deliveryId);
    }

    public String buildMainPanelContext(VelocityPortlet portlet, Context context, RunData rundata, SessionState state) {
        String template = null;
        String mode = (String)state.getAttribute("mode");
        if (mode == null) {
            template = this.buildListContext(state, context);
        } else if (mode.equals("new")) {
            template = this.buildNewContext(state, context);
        } else if (mode.equals("edit")) {
            template = this.buildEditContext(state, context);
        } else if (mode.equals("confirm")) {
            template = this.buildConfirmRemoveContext(state, context);
        } else if (mode.equals("newRole")) {
            template = this.buildNewRoleContext(state, context);
        } else if (mode.equals("editRole")) {
            template = this.buildEditRoleContext(state, context);
        } else if (mode.equals("saveasRole")) {
            template = this.buildSaveasRoleContext(state, context);
        } else if (mode.equals("newUser")) {
            template = this.buildNewUserContext(state, context);
        } else if (mode.equals("editUser")) {
            template = this.buildEditUserContext(state, context);
        } else {
            Log.warn("chef", "RealmsAction: mode: " + mode);
            template = this.buildListContext(state, context);
        }
        return template;
    }

    private String buildListContext(SessionState state, Context context) {
        context.put("service", RealmService.getInstance());
        List realms = RealmService.getRealms();
        Collections.sort(realms);
        context.put("realms", realms);
        boolean menuPopulated = false;
        Menu bar = new Menu();
        if (RealmService.allowAddRealm("")) {
            bar.add(new MenuEntry("New Realm", "doNew"));
            menuPopulated = true;
        }
        if (menuPopulated) {
            context.put("menu", bar);
        }
        ((EventObservingCourier)state.getAttribute("obsever")).justDelivered();
        return "chef_realms_list";
    }

    private String buildNewContext(SessionState state, Context context) {
        context.put("form-name", "realm-form");
        return "chef_realms_edit";
    }

    private String buildEditContext(SessionState state, Context context) {
        RealmEdit realm = (RealmEdit)state.getAttribute("realm");
        context.put("realm", realm);
        Vector roles = new Vector();
        roles.addAll(realm.getRoles());
        Collections.sort(roles);
        context.put("roles", roles);
        Vector users = new Vector();
        users.addAll(realm.getUsers());
        Collections.sort(users);
        context.put("users", users);
        context.put("form-name", "realm-form");
        Menu bar = new Menu();
        if (RealmService.allowRemoveRealm(realm.getId())) {
            bar.add(new MenuEntry("Remove Realm", null, true, 0, "doRemove", "realm-form"));
        }
        bar.add(new MenuEntry("Add Role", null, true, 0, "doNew_role", "realm-form"));
        bar.add(new MenuEntry("Grant Ability", null, true, 0, "doNew_user", "realm-form"));
        context.put("menu", bar);
        return "chef_realms_edit";
    }

    private String buildConfirmRemoveContext(SessionState state, Context context) {
        RealmEdit realm = (RealmEdit)state.getAttribute("realm");
        context.put("realm", realm);
        return "chef_realms_confirm_remove";
    }

    private String buildSaveasRoleContext(SessionState state, Context context) {
        RealmEdit realm = (RealmEdit)state.getAttribute("realm");
        context.put("realm", realm);
        RoleEdit role = (RoleEdit)state.getAttribute("role");
        context.put("role", role);
        return "chef_realms_saveas_role";
    }

    private String buildNewRoleContext(SessionState state, Context context) {
        context.put("form-name", "role-form");
        RealmEdit realm = (RealmEdit)state.getAttribute("realm");
        context.put("realm", realm);
        List allLocks = ServerConfigurationService.getLocks();
        Collections.sort(allLocks);
        context.put("allLocks", allLocks);
        Vector allRoles = new Vector();
        allRoles.addAll(realm.getRoles());
        Collections.sort(allRoles);
        context.put("allRoles", allRoles);
        return "chef_realms_edit_role";
    }

    private String buildEditRoleContext(SessionState state, Context context) {
        context.put("form-name", "role-form");
        RealmEdit realm = (RealmEdit)state.getAttribute("realm");
        context.put("realm", realm);
        RoleEdit role = (RoleEdit)state.getAttribute("role");
        context.put("role", role);
        List allLocks = ServerConfigurationService.getLocks();
        Collections.sort(allLocks);
        context.put("allLocks", allLocks);
        Vector allRoles = new Vector();
        allRoles.addAll(realm.getRoles());
        Collections.sort(allRoles);
        context.put("allRoles", allRoles);
        Menu bar = new Menu();
        bar.add(new MenuEntry("Remove Role", null, true, 0, "doRemove_role"));
        bar.add(new MenuEntry("Copy Role...", null, true, 0, "doSaveas_role", "role-form"));
        context.put("menu", bar);
        return "chef_realms_edit_role";
    }

    private String buildNewUserContext(SessionState state, Context context) {
        context.put("form-name", "user-form");
        RealmEdit realm = (RealmEdit)state.getAttribute("realm");
        context.put("realm", realm);
        List allLocks = ServerConfigurationService.getLocks();
        Collections.sort(allLocks);
        context.put("allLocks", allLocks);
        Vector allRoles = new Vector();
        allRoles.addAll(realm.getRoles());
        Collections.sort(allRoles);
        context.put("allRoles", allRoles);
        return "chef_realms_edit_user";
    }

    private String buildEditUserContext(SessionState state, Context context) {
        context.put("form-name", "user-form");
        RealmEdit realm = (RealmEdit)state.getAttribute("realm");
        User user = (User)state.getAttribute("user");
        context.put("realm", realm);
        context.put("user", user);
        Set locks = realm.getUserLocks(user);
        Set roles = realm.getUserRoles(user);
        context.put("locks", locks);
        context.put("roles", roles);
        List allLocks = ServerConfigurationService.getLocks();
        Collections.sort(allLocks);
        context.put("allLocks", allLocks);
        Vector allRoles = new Vector();
        allRoles.addAll(realm.getRoles());
        Collections.sort(allRoles);
        context.put("allRoles", allRoles);
        Menu bar = new Menu();
        bar.add(new MenuEntry("Remove All", null, true, 0, "doRemove_user"));
        context.put("menu", bar);
        return "chef_realms_edit_user";
    }

    public void doNew(RunData data, Context context) {
        SessionState state = ((JetspeedRunData)data).getPortletSessionState(((JetspeedRunData)data).getJs_peid());
        state.setAttribute("mode", (Object)"new");
        state.setAttribute("new", (Object)"true");
        ((EventObservingCourier)state.getAttribute("obsever")).disable();
    }

    public void doEdit(RunData data, Context context) {
        SessionState state = ((JetspeedRunData)data).getPortletSessionState(((JetspeedRunData)data).getJs_peid());
        String id = data.getParameters().getString("id");
        try {
            RealmEdit realm = RealmService.editRealm(id);
            state.setAttribute("realm", (Object)realm);
            state.setAttribute("mode", (Object)"edit");
            ((EventObservingCourier)state.getAttribute("obsever")).disable();
        }
        catch (IdUnusedException e) {
            Log.warn("chef", "RealmsAction.doEdit: realm not found: " + id);
            this.addAlert(state, "Realm " + id + " not found");
            state.removeAttribute("mode");
            ((EventObservingCourier)state.getAttribute("obsever")).enable();
        }
        catch (PermissionException e) {
            this.addAlert(state, "You do not have permission to edit Realm " + id);
            state.removeAttribute("mode");
            ((EventObservingCourier)state.getAttribute("obsever")).enable();
        }
        catch (InUseException e) {
            this.addAlert(state, "Someone else is currently editing this Realm: " + id);
            state.removeAttribute("mode");
            ((EventObservingCourier)state.getAttribute("obsever")).enable();
        }
    }

    public void doSave(RunData data, Context context) {
        SessionState state = ((JetspeedRunData)data).getPortletSessionState(((JetspeedRunData)data).getJs_peid());
        if (!this.readRealmForm(data, state)) {
            return;
        }
        this.doSave_edit(data, context);
    }

    public void doSave_edit(RunData data, Context context) {
        SessionState state = ((JetspeedRunData)data).getPortletSessionState(((JetspeedRunData)data).getJs_peid());
        RealmEdit realm = (RealmEdit)state.getAttribute("realm");
        if (realm != null) {
            RealmService.commitEdit(realm);
        }
        this.cleanState(state);
        state.removeAttribute("mode");
        ((EventObservingCourier)state.getAttribute("obsever")).enable();
    }

    public void doCancel(RunData data, Context context) {
        SessionState state = ((JetspeedRunData)data).getPortletSessionState(((JetspeedRunData)data).getJs_peid());
        RealmEdit realm = (RealmEdit)state.getAttribute("realm");
        if (realm != null) {
            if ("true".equals(state.getAttribute("new"))) {
                try {
                    RealmService.removeRealm(realm);
                }
                catch (IdUnusedException e) {
                    Log.warn("chef", "RealmsAction.doCancel (new): realm id not recognized for remove: " + realm.getId());
                }
                catch (PermissionException e) {
                    this.addAlert(state, "You do not have permission to remove Realm " + realm.getId());
                }
            } else {
                RealmService.cancelEdit(realm);
            }
        }
        this.cleanState(state);
        state.removeAttribute("mode");
        ((EventObservingCourier)state.getAttribute("obsever")).enable();
    }

    public void doRemove(RunData data, Context context) {
        SessionState state = ((JetspeedRunData)data).getPortletSessionState(((JetspeedRunData)data).getJs_peid());
        if (!this.readRealmForm(data, state)) {
            return;
        }
        state.setAttribute("mode", (Object)"confirm");
        ((EventObservingCourier)state.getAttribute("obsever")).disable();
    }

    public void doRemove_confirmed(RunData data, Context context) {
        SessionState state = ((JetspeedRunData)data).getPortletSessionState(((JetspeedRunData)data).getJs_peid());
        RealmEdit realm = (RealmEdit)state.getAttribute("realm");
        try {
            RealmService.removeRealm(realm);
        }
        catch (IdUnusedException e) {
            Log.warn("chef", "RealmsAction.doRemove_confirmed: realm id not recognized: " + realm.getId());
        }
        catch (PermissionException e) {
            this.addAlert(state, "You do not have permission to remove Realm " + realm.getId());
        }
        this.cleanState(state);
        state.removeAttribute("mode");
        ((EventObservingCourier)state.getAttribute("obsever")).enable();
    }

    public void doCancel_remove(RunData data, Context context) {
        SessionState state = ((JetspeedRunData)data).getPortletSessionState(((JetspeedRunData)data).getJs_peid());
        state.setAttribute("mode", (Object)"edit");
    }

    private boolean readRealmForm(RunData data, SessionState state) {
        String id = data.getParameters().getString("id");
        String provider = data.getParameters().getString("provider");
        RealmEdit realm = (RealmEdit)state.getAttribute("realm");
        if (realm == null) {
            try {
                realm = RealmService.addRealm(id);
                state.setAttribute("realm", (Object)realm);
            }
            catch (IdUsedException e) {
                this.addAlert(state, "The realm id is already in use");
                return false;
            }
            catch (IdInvalidException e) {
                this.addAlert(state, "The realm id is invalid");
                return false;
            }
            catch (PermissionException e) {
                this.addAlert(state, "You do not have permission to edit this Realm");
                return false;
            }
        }
        if (realm != null) {
            realm.setProviderRealmId(provider);
        }
        return true;
    }

    public void doNew_role(RunData data, Context context) {
        SessionState state = ((JetspeedRunData)data).getPortletSessionState(((JetspeedRunData)data).getJs_peid());
        state.setAttribute("mode", (Object)"newRole");
        if (!this.readRealmForm(data, state)) {
            return;
        }
        state.setAttribute("newRole", (Object)"true");
    }

    public void doEdit_role(RunData data, Context context) {
        SessionState state = ((JetspeedRunData)data).getPortletSessionState(((JetspeedRunData)data).getJs_peid());
        if (!this.readRealmForm(data, state)) {
            return;
        }
        state.setAttribute("mode", (Object)"editRole");
        String id = data.getParameters().getString("target");
        RealmEdit realm = (RealmEdit)state.getAttribute("realm");
        RoleEdit role = realm.getRoleEdit(id);
        state.setAttribute("role", (Object)role);
    }

    public void doRemove_role(RunData data, Context context) {
        SessionState state = ((JetspeedRunData)data).getPortletSessionState(((JetspeedRunData)data).getJs_peid());
        RealmEdit realm = (RealmEdit)state.getAttribute("realm");
        RoleEdit role = (RoleEdit)state.getAttribute("role");
        realm.removeRole(role);
        state.removeAttribute("role");
        state.setAttribute("mode", (Object)"edit");
    }

    public void doSaveas_role(RunData data, Context context) {
        SessionState state = ((JetspeedRunData)data).getPortletSessionState(((JetspeedRunData)data).getJs_peid());
        if (!this.readRoleForm(data, state)) {
            return;
        }
        state.setAttribute("mode", (Object)"saveasRole");
    }

    public void doSave_role_as(RunData data, Context context) {
        SessionState state = ((JetspeedRunData)data).getPortletSessionState(((JetspeedRunData)data).getJs_peid());
        if (!this.readRoleSaveAsForm(data, state)) {
            return;
        }
        state.removeAttribute("role");
        state.setAttribute("mode", (Object)"edit");
    }

    public void doCancel_role_saveas(RunData data, Context context) {
        SessionState state = ((JetspeedRunData)data).getPortletSessionState(((JetspeedRunData)data).getJs_peid());
        state.removeAttribute("role");
        state.setAttribute("mode", (Object)"edit");
    }

    public void doSave_role(RunData data, Context context) {
        SessionState state = ((JetspeedRunData)data).getPortletSessionState(((JetspeedRunData)data).getJs_peid());
        if (!this.readRoleForm(data, state)) {
            return;
        }
        this.doSave_edit(data, context);
    }

    public void doDone_role(RunData data, Context context) {
        SessionState state = ((JetspeedRunData)data).getPortletSessionState(((JetspeedRunData)data).getJs_peid());
        if (!this.readRoleForm(data, state)) {
            return;
        }
        state.removeAttribute("role");
        state.setAttribute("mode", (Object)"edit");
    }

    private boolean readRoleForm(RunData data, SessionState state) {
        RealmEdit realm = (RealmEdit)state.getAttribute("realm");
        String[] locks = data.getParameters().getStrings("locks");
        String[] roles = data.getParameters().getStrings("roles");
        RoleEdit role = (RoleEdit)state.getAttribute("role");
        if (role == null) {
            String id = StringUtil.trimToNull(data.getParameters().getString("id"));
            if (id == null && locks == null && roles == null) {
                return true;
            }
            if (id == null) {
                this.addAlert(state, "Please enter a Role id.");
                return false;
            }
            try {
                role = realm.addRole(id);
            }
            catch (IdUsedException e) {
                this.addAlert(state, "A Role with this id (" + id + ") is already defined.");
                return false;
            }
        }
        role.clear();
        if (locks != null) {
            int i = 0;
            while (i < locks.length) {
                role.addLock(locks[i]);
                ++i;
            }
        }
        if (roles != null) {
            int i = 0;
            while (i < roles.length) {
                Role nested = realm.getRole(roles[i]);
                if (!nested.equals(role)) {
                    role.addRole(nested);
                }
                ++i;
            }
        }
        return true;
    }

    private boolean readRoleSaveAsForm(RunData data, SessionState state) {
        RealmEdit realm = (RealmEdit)state.getAttribute("realm");
        RoleEdit role = (RoleEdit)state.getAttribute("role");
        String id = StringUtil.trimToNull(data.getParameters().getString("id"));
        if (id == null) {
            this.addAlert(state, "Please enter a Role id.");
            return false;
        }
        try {
            RoleEdit newRole = realm.addRole(id, role);
        }
        catch (IdUsedException e) {
            this.addAlert(state, "A Role with this id (" + id + ") is already defined.");
            return false;
        }
        return true;
    }

    public void doNew_user(RunData data, Context context) {
        SessionState state = ((JetspeedRunData)data).getPortletSessionState(((JetspeedRunData)data).getJs_peid());
        if (!this.readRealmForm(data, state)) {
            return;
        }
        state.setAttribute("mode", (Object)"newUser");
        state.setAttribute("newUser", (Object)"true");
    }

    public void doEdit_user(RunData data, Context context) {
        SessionState state = ((JetspeedRunData)data).getPortletSessionState(((JetspeedRunData)data).getJs_peid());
        if (!this.readRealmForm(data, state)) {
            return;
        }
        String id = data.getParameters().getString("target");
        try {
            User user = UserDirectoryService.getUser(id);
            state.setAttribute("user", (Object)user);
            state.setAttribute("mode", (Object)"editUser");
        }
        catch (IdUnusedException e) {
            Log.warn("chef", (Object)((Object)this) + "doEdit_user(): user not found: " + id);
            state.setAttribute("message", (Object)"internal error: user not found.");
        }
    }

    public void doRemove_user(RunData data, Context context) {
        SessionState state = ((JetspeedRunData)data).getPortletSessionState(((JetspeedRunData)data).getJs_peid());
        User user = (User)state.getAttribute("user");
        RealmEdit realm = (RealmEdit)state.getAttribute("realm");
        realm.removeUser(user);
        state.removeAttribute("user");
        state.setAttribute("mode", (Object)"edit");
    }

    public void doSave_user(RunData data, Context context) {
        SessionState state = ((JetspeedRunData)data).getPortletSessionState(((JetspeedRunData)data).getJs_peid());
        if (!this.readUserForm(data, state)) {
            return;
        }
        this.doSave_edit(data, context);
    }

    public void doDone_user(RunData data, Context context) {
        SessionState state = ((JetspeedRunData)data).getPortletSessionState(((JetspeedRunData)data).getJs_peid());
        if (!this.readUserForm(data, state)) {
            return;
        }
        state.removeAttribute("user");
        state.setAttribute("mode", (Object)"edit");
    }

    private boolean readUserForm(RunData data, SessionState state) {
        int i;
        String[] locks = data.getParameters().getStrings("locks");
        String[] roles = data.getParameters().getStrings("roles");
        User user = (User)state.getAttribute("user");
        if (user == null) {
            String id = StringUtil.trimToNull(data.getParameters().getString("id"));
            if (id == null && locks == null && roles == null) {
                return true;
            }
            try {
                user = UserDirectoryService.getUser(id);
            }
            catch (IdUnusedException e) {
                this.addAlert(state, "User id not found.");
                return false;
            }
        }
        RealmEdit realm = (RealmEdit)state.getAttribute("realm");
        realm.removeUser(user);
        if (locks != null) {
            i = 0;
            while (i < locks.length) {
                realm.addUserLock(user, locks[i]);
                ++i;
            }
        }
        if (roles != null) {
            i = 0;
            while (i < roles.length) {
                Role role = realm.getRole(roles[i]);
                realm.addUserRole(user, role);
                ++i;
            }
        }
        return true;
    }

    private void cleanState(SessionState state) {
        state.removeAttribute("realm");
        state.removeAttribute("role");
        state.removeAttribute("user");
        state.removeAttribute("new");
        state.removeAttribute("newRole");
        state.removeAttribute("newUser");
        state.removeAttribute("allRoles");
        state.removeAttribute("allLocks");
        state.removeAttribute("roles");
        state.removeAttribute("locks");
    }
}

