package validator

var iso3166_1_alpha2 = map[string]struct{}{
	// see: https://www.iso.org/iso-3166-country-codes.html
	"AF": {}, "AX": {}, "AL": {}, "DZ": {}, "AS": {},
	"AD": {}, "AO": {}, "AI": {}, "AQ": {}, "AG": {},
	"AR": {}, "AM": {}, "AW": {}, "AU": {}, "AT": {},
	"AZ": {}, "BS": {}, "BH": {}, "BD": {}, "BB": {},
	"BY": {}, "BE": {}, "BZ": {}, "BJ": {}, "BM": {},
	"BT": {}, "BO": {}, "BQ": {}, "BA": {}, "BW": {},
	"BV": {}, "BR": {}, "IO": {}, "BN": {}, "BG": {},
	"BF": {}, "BI": {}, "KH": {}, "CM": {}, "CA": {},
	"CV": {}, "KY": {}, "CF": {}, "TD": {}, "CL": {},
	"CN": {}, "CX": {}, "CC": {}, "CO": {}, "KM": {},
	"CG": {}, "CD": {}, "CK": {}, "CR": {}, "CI": {},
	"HR": {}, "CU": {}, "CW": {}, "CY": {}, "CZ": {},
	"DK": {}, "DJ": {}, "DM": {}, "DO": {}, "EC": {},
	"EG": {}, "SV": {}, "GQ": {}, "ER": {}, "EE": {},
	"ET": {}, "FK": {}, "FO": {}, "FJ": {}, "FI": {},
	"FR": {}, "GF": {}, "PF": {}, "TF": {}, "GA": {},
	"GM": {}, "GE": {}, "DE": {}, "GH": {}, "GI": {},
	"GR": {}, "GL": {}, "GD": {}, "GP": {}, "GU": {},
	"GT": {}, "GG": {}, "GN": {}, "GW": {}, "GY": {},
	"HT": {}, "HM": {}, "VA": {}, "HN": {}, "HK": {},
	"HU": {}, "IS": {}, "IN": {}, "ID": {}, "IR": {},
	"IQ": {}, "IE": {}, "IM": {}, "IL": {}, "IT": {},
	"JM": {}, "JP": {}, "JE": {}, "JO": {}, "KZ": {},
	"KE": {}, "KI": {}, "KP": {}, "KR": {}, "KW": {},
	"KG": {}, "LA": {}, "LV": {}, "LB": {}, "LS": {},
	"LR": {}, "LY": {}, "LI": {}, "LT": {}, "LU": {},
	"MO": {}, "MK": {}, "MG": {}, "MW": {}, "MY": {},
	"MV": {}, "ML": {}, "MT": {}, "MH": {}, "MQ": {},
	"MR": {}, "MU": {}, "YT": {}, "MX": {}, "FM": {},
	"MD": {}, "MC": {}, "MN": {}, "ME": {}, "MS": {},
	"MA": {}, "MZ": {}, "MM": {}, "NA": {}, "NR": {},
	"NP": {}, "NL": {}, "NC": {}, "NZ": {}, "NI": {},
	"NE": {}, "NG": {}, "NU": {}, "NF": {}, "MP": {},
	"NO": {}, "OM": {}, "PK": {}, "PW": {}, "PS": {},
	"PA": {}, "PG": {}, "PY": {}, "PE": {}, "PH": {},
	"PN": {}, "PL": {}, "PT": {}, "PR": {}, "QA": {},
	"RE": {}, "RO": {}, "RU": {}, "RW": {}, "BL": {},
	"SH": {}, "KN": {}, "LC": {}, "MF": {}, "PM": {},
	"VC": {}, "WS": {}, "SM": {}, "ST": {}, "SA": {},
	"SN": {}, "RS": {}, "SC": {}, "SL": {}, "SG": {},
	"SX": {}, "SK": {}, "SI": {}, "SB": {}, "SO": {},
	"ZA": {}, "GS": {}, "SS": {}, "ES": {}, "LK": {},
	"SD": {}, "SR": {}, "SJ": {}, "SZ": {}, "SE": {},
	"CH": {}, "SY": {}, "TW": {}, "TJ": {}, "TZ": {},
	"TH": {}, "TL": {}, "TG": {}, "TK": {}, "TO": {},
	"TT": {}, "TN": {}, "TR": {}, "TM": {}, "TC": {},
	"TV": {}, "UG": {}, "UA": {}, "AE": {}, "GB": {},
	"US": {}, "UM": {}, "UY": {}, "UZ": {}, "VU": {},
	"VE": {}, "VN": {}, "VG": {}, "VI": {}, "WF": {},
	"EH": {}, "YE": {}, "ZM": {}, "ZW": {}, "XK": {},
}

var iso3166_1_alpha2_eu = map[string]struct{}{
	"AT": {}, "BE": {}, "BG": {}, "HR": {}, "CY": {},
	"CZ": {}, "DK": {}, "EE": {}, "FI": {}, "FR": {},
	"DE": {}, "GR": {}, "HU": {}, "IE": {}, "IT": {},
	"LV": {}, "LT": {}, "LU": {}, "MT": {}, "NL": {},
	"PL": {}, "PT": {}, "RO": {}, "SK": {}, "SI": {},
	"ES": {}, "SE": {},
}

var iso3166_1_alpha3 = map[string]struct{}{
	// see: https://www.iso.org/iso-3166-country-codes.html
	"AFG": {}, "ALB": {}, "DZA": {}, "ASM": {}, "AND": {},
	"AGO": {}, "AIA": {}, "ATA": {}, "ATG": {}, "ARG": {},
	"ARM": {}, "ABW": {}, "AUS": {}, "AUT": {}, "AZE": {},
	"BHS": {}, "BHR": {}, "BGD": {}, "BRB": {}, "BLR": {},
	"BEL": {}, "BLZ": {}, "BEN": {}, "BMU": {}, "BTN": {},
	"BOL": {}, "BES": {}, "BIH": {}, "BWA": {}, "BVT": {},
	"BRA": {}, "IOT": {}, "BRN": {}, "BGR": {}, "BFA": {},
	"BDI": {}, "CPV": {}, "KHM": {}, "CMR": {}, "CAN": {},
	"CYM": {}, "CAF": {}, "TCD": {}, "CHL": {}, "CHN": {},
	"CXR": {}, "CCK": {}, "COL": {}, "COM": {}, "COD": {},
	"COG": {}, "COK": {}, "CRI": {}, "HRV": {}, "CUB": {},
	"CUW": {}, "CYP": {}, "CZE": {}, "CIV": {}, "DNK": {},
	"DJI": {}, "DMA": {}, "DOM": {}, "ECU": {}, "EGY": {},
	"SLV": {}, "GNQ": {}, "ERI": {}, "EST": {}, "SWZ": {},
	"ETH": {}, "FLK": {}, "FRO": {}, "FJI": {}, "FIN": {},
	"FRA": {}, "GUF": {}, "PYF": {}, "ATF": {}, "GAB": {},
	"GMB": {}, "GEO": {}, "DEU": {}, "GHA": {}, "GIB": {},
	"GRC": {}, "GRL": {}, "GRD": {}, "GLP": {}, "GUM": {},
	"GTM": {}, "GGY": {}, "GIN": {}, "GNB": {}, "GUY": {},
	"HTI": {}, "HMD": {}, "VAT": {}, "HND": {}, "HKG": {},
	"HUN": {}, "ISL": {}, "IND": {}, "IDN": {}, "IRN": {},
	"IRQ": {}, "IRL": {}, "IMN": {}, "ISR": {}, "ITA": {},
	"JAM": {}, "JPN": {}, "JEY": {}, "JOR": {}, "KAZ": {},
	"KEN": {}, "KIR": {}, "PRK": {}, "KOR": {}, "KWT": {},
	"KGZ": {}, "LAO": {}, "LVA": {}, "LBN": {}, "LSO": {},
	"LBR": {}, "LBY": {}, "LIE": {}, "LTU": {}, "LUX": {},
	"MAC": {}, "MDG": {}, "MWI": {}, "MYS": {}, "MDV": {},
	"MLI": {}, "MLT": {}, "MHL": {}, "MTQ": {}, "MRT": {},
	"MUS": {}, "MYT": {}, "MEX": {}, "FSM": {}, "MDA": {},
	"MCO": {}, "MNG": {}, "MNE": {}, "MSR": {}, "MAR": {},
	"MOZ": {}, "MMR": {}, "NAM": {}, "NRU": {}, "NPL": {},
	"NLD": {}, "NCL": {}, "NZL": {}, "NIC": {}, "NER": {},
	"NGA": {}, "NIU": {}, "NFK": {}, "MKD": {}, "MNP": {},
	"NOR": {}, "OMN": {}, "PAK": {}, "PLW": {}, "PSE": {},
	"PAN": {}, "PNG": {}, "PRY": {}, "PER": {}, "PHL": {},
	"PCN": {}, "POL": {}, "PRT": {}, "PRI": {}, "QAT": {},
	"ROU": {}, "RUS": {}, "RWA": {}, "REU": {}, "BLM": {},
	"SHN": {}, "KNA": {}, "LCA": {}, "MAF": {}, "SPM": {},
	"VCT": {}, "WSM": {}, "SMR": {}, "STP": {}, "SAU": {},
	"SEN": {}, "SRB": {}, "SYC": {}, "SLE": {}, "SGP": {},
	"SXM": {}, "SVK": {}, "SVN": {}, "SLB": {}, "SOM": {},
	"ZAF": {}, "SGS": {}, "SSD": {}, "ESP": {}, "LKA": {},
	"SDN": {}, "SUR": {}, "SJM": {}, "SWE": {}, "CHE": {},
	"SYR": {}, "TWN": {}, "TJK": {}, "TZA": {}, "THA": {},
	"TLS": {}, "TGO": {}, "TKL": {}, "TON": {}, "TTO": {},
	"TUN": {}, "TUR": {}, "TKM": {}, "TCA": {}, "TUV": {},
	"UGA": {}, "UKR": {}, "ARE": {}, "GBR": {}, "UMI": {},
	"USA": {}, "URY": {}, "UZB": {}, "VUT": {}, "VEN": {},
	"VNM": {}, "VGB": {}, "VIR": {}, "WLF": {}, "ESH": {},
	"YEM": {}, "ZMB": {}, "ZWE": {}, "ALA": {}, "UNK": {},
}

var iso3166_1_alpha3_eu = map[string]struct{}{
	"AUT": {}, "BEL": {}, "BGR": {}, "HRV": {}, "CYP": {},
	"CZE": {}, "DNK": {}, "EST": {}, "FIN": {}, "FRA": {},
	"DEU": {}, "GRC": {}, "HUN": {}, "IRL": {}, "ITA": {},
	"LVA": {}, "LTU": {}, "LUX": {}, "MLT": {}, "NLD": {},
	"POL": {}, "PRT": {}, "ROU": {}, "SVK": {}, "SVN": {},
	"ESP": {}, "SWE": {},
}
var iso3166_1_alpha_numeric = map[int]struct{}{
	// see: https://www.iso.org/iso-3166-country-codes.html
	4: {}, 8: {}, 12: {}, 16: {}, 20: {},
	24: {}, 660: {}, 10: {}, 28: {}, 32: {},
	51: {}, 533: {}, 36: {}, 40: {}, 31: {},
	44: {}, 48: {}, 50: {}, 52: {}, 112: {},
	56: {}, 84: {}, 204: {}, 60: {}, 64: {},
	68: {}, 535: {}, 70: {}, 72: {}, 74: {},
	76: {}, 86: {}, 96: {}, 100: {}, 854: {},
	108: {}, 132: {}, 116: {}, 120: {}, 124: {},
	136: {}, 140: {}, 148: {}, 152: {}, 156: {},
	162: {}, 166: {}, 170: {}, 174: {}, 180: {},
	178: {}, 184: {}, 188: {}, 191: {}, 192: {},
	531: {}, 196: {}, 203: {}, 384: {}, 208: {},
	262: {}, 212: {}, 214: {}, 218: {}, 818: {},
	222: {}, 226: {}, 232: {}, 233: {}, 748: {},
	231: {}, 238: {}, 234: {}, 242: {}, 246: {},
	250: {}, 254: {}, 258: {}, 260: {}, 266: {},
	270: {}, 268: {}, 276: {}, 288: {}, 292: {},
	300: {}, 304: {}, 308: {}, 312: {}, 316: {},
	320: {}, 831: {}, 324: {}, 624: {}, 328: {},
	332: {}, 334: {}, 336: {}, 340: {}, 344: {},
	348: {}, 352: {}, 356: {}, 360: {}, 364: {},
	368: {}, 372: {}, 833: {}, 376: {}, 380: {},
	388: {}, 392: {}, 832: {}, 400: {}, 398: {},
	404: {}, 296: {}, 408: {}, 410: {}, 414: {},
	417: {}, 418: {}, 428: {}, 422: {}, 426: {},
	430: {}, 434: {}, 438: {}, 440: {}, 442: {},
	446: {}, 450: {}, 454: {}, 458: {}, 462: {},
	466: {}, 470: {}, 584: {}, 474: {}, 478: {},
	480: {}, 175: {}, 484: {}, 583: {}, 498: {},
	492: {}, 496: {}, 499: {}, 500: {}, 504: {},
	508: {}, 104: {}, 516: {}, 520: {}, 524: {},
	528: {}, 540: {}, 554: {}, 558: {}, 562: {},
	566: {}, 570: {}, 574: {}, 807: {}, 580: {},
	578: {}, 512: {}, 586: {}, 585: {}, 275: {},
	591: {}, 598: {}, 600: {}, 604: {}, 608: {},
	612: {}, 616: {}, 620: {}, 630: {}, 634: {},
	642: {}, 643: {}, 646: {}, 638: {}, 652: {},
	654: {}, 659: {}, 662: {}, 663: {}, 666: {},
	670: {}, 882: {}, 674: {}, 678: {}, 682: {},
	686: {}, 688: {}, 690: {}, 694: {}, 702: {},
	534: {}, 703: {}, 705: {}, 90: {}, 706: {},
	710: {}, 239: {}, 728: {}, 724: {}, 144: {},
	729: {}, 740: {}, 744: {}, 752: {}, 756: {},
	760: {}, 158: {}, 762: {}, 834: {}, 764: {},
	626: {}, 768: {}, 772: {}, 776: {}, 780: {},
	788: {}, 792: {}, 795: {}, 796: {}, 798: {},
	800: {}, 804: {}, 784: {}, 826: {}, 581: {},
	840: {}, 858: {}, 860: {}, 548: {}, 862: {},
	704: {}, 92: {}, 850: {}, 876: {}, 732: {},
	887: {}, 894: {}, 716: {}, 248: {}, 153: {},
}

var iso3166_1_alpha_numeric_eu = map[int]struct{}{
	40: {}, 56: {}, 100: {}, 191: {}, 196: {},
	200: {}, 208: {}, 233: {}, 246: {}, 250: {},
	276: {}, 300: {}, 348: {}, 372: {}, 380: {},
	428: {}, 440: {}, 442: {}, 470: {}, 528: {},
	616: {}, 620: {}, 642: {}, 703: {}, 705: {},
	724: {}, 752: {},
}

var iso3166_2 = map[string]struct{}{
	"AD-02": {}, "AD-03": {}, "AD-04": {}, "AD-05": {}, "AD-06": {},
	"AD-07": {}, "AD-08": {}, "AE-AJ": {}, "AE-AZ": {}, "AE-DU": {},
	"AE-FU": {}, "AE-RK": {}, "AE-SH": {}, "AE-UQ": {}, "AF-BAL": {},
	"AF-BAM": {}, "AF-BDG": {}, "AF-BDS": {}, "AF-BGL": {}, "AF-DAY": {},
	"AF-FRA": {}, "AF-FYB": {}, "AF-GHA": {}, "AF-GHO": {}, "AF-HEL": {},
	"AF-HER": {}, "AF-JOW": {}, "AF-KAB": {}, "AF-KAN": {}, "AF-KAP": {},
	"AF-KDZ": {}, "AF-KHO": {}, "AF-KNR": {}, "AF-LAG": {}, "AF-LOG": {},
	"AF-NAN": {}, "AF-NIM": {}, "AF-NUR": {}, "AF-PAN": {}, "AF-PAR": {},
	"AF-PIA": {}, "AF-PKA": {}, "AF-SAM": {}, "AF-SAR": {}, "AF-TAK": {},
	"AF-URU": {}, "AF-WAR": {}, "AF-ZAB": {}, "AG-03": {}, "AG-04": {},
	"AG-05": {}, "AG-06": {}, "AG-07": {}, "AG-08": {}, "AG-10": {},
	"AG-11": {}, "AL-01": {}, "AL-02": {}, "AL-03": {}, "AL-04": {},
	"AL-05": {}, "AL-06": {}, "AL-07": {}, "AL-08": {}, "AL-09": {},
	"AL-10": {}, "AL-11": {}, "AL-12": {}, "AL-BR": {}, "AL-BU": {},
	"AL-DI": {}, "AL-DL": {}, "AL-DR": {}, "AL-DV": {}, "AL-EL": {},
	"AL-ER": {}, "AL-FR": {}, "AL-GJ": {}, "AL-GR": {}, "AL-HA": {},
	"AL-KA": {}, "AL-KB": {}, "AL-KC": {}, "AL-KO": {}, "AL-KR": {},
	"AL-KU": {}, "AL-LB": {}, "AL-LE": {}, "AL-LU": {}, "AL-MK": {},
	"AL-MM": {}, "AL-MR": {}, "AL-MT": {}, "AL-PG": {}, "AL-PQ": {},
	"AL-PR": {}, "AL-PU": {}, "AL-SH": {}, "AL-SK": {}, "AL-SR": {},
	"AL-TE": {}, "AL-TP": {}, "AL-TR": {}, "AL-VL": {}, "AM-AG": {},
	"AM-AR": {}, "AM-AV": {}, "AM-ER": {}, "AM-GR": {}, "AM-KT": {},
	"AM-LO": {}, "AM-SH": {}, "AM-SU": {}, "AM-TV": {}, "AM-VD": {},
	"AO-BGO": {}, "AO-BGU": {}, "AO-BIE": {}, "AO-CAB": {}, "AO-CCU": {},
	"AO-CNN": {}, "AO-CNO": {}, "AO-CUS": {}, "AO-HUA": {}, "AO-HUI": {},
	"AO-LNO": {}, "AO-LSU": {}, "AO-LUA": {}, "AO-MAL": {}, "AO-MOX": {},
	"AO-NAM": {}, "AO-UIG": {}, "AO-ZAI": {}, "AR-A": {}, "AR-B": {},
	"AR-C": {}, "AR-D": {}, "AR-E": {}, "AR-F": {}, "AR-G": {}, "AR-H": {},
	"AR-J": {}, "AR-K": {}, "AR-L": {}, "AR-M": {}, "AR-N": {},
	"AR-P": {}, "AR-Q": {}, "AR-R": {}, "AR-S": {}, "AR-T": {},
	"AR-U": {}, "AR-V": {}, "AR-W": {}, "AR-X": {}, "AR-Y": {},
	"AR-Z": {}, "AT-1": {}, "AT-2": {}, "AT-3": {}, "AT-4": {},
	"AT-5": {}, "AT-6": {}, "AT-7": {}, "AT-8": {}, "AT-9": {},
	"AU-ACT": {}, "AU-NSW": {}, "AU-NT": {}, "AU-QLD": {}, "AU-SA": {},
	"AU-TAS": {}, "AU-VIC": {}, "AU-WA": {}, "AZ-ABS": {}, "AZ-AGA": {},
	"AZ-AGC": {}, "AZ-AGM": {}, "AZ-AGS": {}, "AZ-AGU": {}, "AZ-AST": {},
	"AZ-BA": {}, "AZ-BAB": {}, "AZ-BAL": {}, "AZ-BAR": {}, "AZ-BEY": {},
	"AZ-BIL": {}, "AZ-CAB": {}, "AZ-CAL": {}, "AZ-CUL": {}, "AZ-DAS": {},
	"AZ-FUZ": {}, "AZ-GA": {}, "AZ-GAD": {}, "AZ-GOR": {}, "AZ-GOY": {},
	"AZ-GYG": {}, "AZ-HAC": {}, "AZ-IMI": {}, "AZ-ISM": {}, "AZ-KAL": {},
	"AZ-KAN": {}, "AZ-KUR": {}, "AZ-LA": {}, "AZ-LAC": {}, "AZ-LAN": {},
	"AZ-LER": {}, "AZ-MAS": {}, "AZ-MI": {}, "AZ-NA": {}, "AZ-NEF": {},
	"AZ-NV": {}, "AZ-NX": {}, "AZ-OGU": {}, "AZ-ORD": {}, "AZ-QAB": {},
	"AZ-QAX": {}, "AZ-QAZ": {}, "AZ-QBA": {}, "AZ-QBI": {}, "AZ-QOB": {},
	"AZ-QUS": {}, "AZ-SA": {}, "AZ-SAB": {}, "AZ-SAD": {}, "AZ-SAH": {},
	"AZ-SAK": {}, "AZ-SAL": {}, "AZ-SAR": {}, "AZ-SAT": {}, "AZ-SBN": {},
	"AZ-SIY": {}, "AZ-SKR": {}, "AZ-SM": {}, "AZ-SMI": {}, "AZ-SMX": {},
	"AZ-SR": {}, "AZ-SUS": {}, "AZ-TAR": {}, "AZ-TOV": {}, "AZ-UCA": {},
	"AZ-XA": {}, "AZ-XAC": {}, "AZ-XCI": {}, "AZ-XIZ": {}, "AZ-XVD": {},
	"AZ-YAR": {}, "AZ-YE": {}, "AZ-YEV": {}, "AZ-ZAN": {}, "AZ-ZAQ": {},
	"AZ-ZAR": {}, "BA-01": {}, "BA-02": {}, "BA-03": {}, "BA-04": {},
	"BA-05": {}, "BA-06": {}, "BA-07": {}, "BA-08": {}, "BA-09": {},
	"BA-10": {}, "BA-BIH": {}, "BA-BRC": {}, "BA-SRP": {}, "BB-01": {},
	"BB-02": {}, "BB-03": {}, "BB-04": {}, "BB-05": {}, "BB-06": {},
	"BB-07": {}, "BB-08": {}, "BB-09": {}, "BB-10": {}, "BB-11": {},
	"BD-01": {}, "BD-02": {}, "BD-03": {}, "BD-04": {}, "BD-05": {},
	"BD-06": {}, "BD-07": {}, "BD-08": {}, "BD-09": {}, "BD-10": {},
	"BD-11": {}, "BD-12": {}, "BD-13": {}, "BD-14": {}, "BD-15": {},
	"BD-16": {}, "BD-17": {}, "BD-18": {}, "BD-19": {}, "BD-20": {},
	"BD-21": {}, "BD-22": {}, "BD-23": {}, "BD-24": {}, "BD-25": {},
	"BD-26": {}, "BD-27": {}, "BD-28": {}, "BD-29": {}, "BD-30": {},
	"BD-31": {}, "BD-32": {}, "BD-33": {}, "BD-34": {}, "BD-35": {},
	"BD-36": {}, "BD-37": {}, "BD-38": {}, "BD-39": {}, "BD-40": {},
	"BD-41": {}, "BD-42": {}, "BD-43": {}, "BD-44": {}, "BD-45": {},
	"BD-46": {}, "BD-47": {}, "BD-48": {}, "BD-49": {}, "BD-50": {},
	"BD-51": {}, "BD-52": {}, "BD-53": {}, "BD-54": {}, "BD-55": {},
	"BD-56": {}, "BD-57": {}, "BD-58": {}, "BD-59": {}, "BD-60": {},
	"BD-61": {}, "BD-62": {}, "BD-63": {}, "BD-64": {}, "BD-A": {},
	"BD-B": {}, "BD-C": {}, "BD-D": {}, "BD-E": {}, "BD-F": {},
	"BD-G": {}, "BE-BRU": {}, "BE-VAN": {}, "BE-VBR": {}, "BE-VLG": {},
	"BE-VLI": {}, "BE-VOV": {}, "BE-VWV": {}, "BE-WAL": {}, "BE-WBR": {},
	"BE-WHT": {}, "BE-WLG": {}, "BE-WLX": {}, "BE-WNA": {}, "BF-01": {},
	"BF-02": {}, "BF-03": {}, "BF-04": {}, "BF-05": {}, "BF-06": {},
	"BF-07": {}, "BF-08": {}, "BF-09": {}, "BF-10": {}, "BF-11": {},
	"BF-12": {}, "BF-13": {}, "BF-BAL": {}, "BF-BAM": {}, "BF-BAN": {},
	"BF-BAZ": {}, "BF-BGR": {}, "BF-BLG": {}, "BF-BLK": {}, "BF-COM": {},
	"BF-GAN": {}, "BF-GNA": {}, "BF-GOU": {}, "BF-HOU": {}, "BF-IOB": {},
	"BF-KAD": {}, "BF-KEN": {}, "BF-KMD": {}, "BF-KMP": {}, "BF-KOP": {},
	"BF-KOS": {}, "BF-KOT": {}, "BF-KOW": {}, "BF-LER": {}, "BF-LOR": {},
	"BF-MOU": {}, "BF-NAM": {}, "BF-NAO": {}, "BF-NAY": {}, "BF-NOU": {},
	"BF-OUB": {}, "BF-OUD": {}, "BF-PAS": {}, "BF-PON": {}, "BF-SEN": {},
	"BF-SIS": {}, "BF-SMT": {}, "BF-SNG": {}, "BF-SOM": {}, "BF-SOR": {},
	"BF-TAP": {}, "BF-TUI": {}, "BF-YAG": {}, "BF-YAT": {}, "BF-ZIR": {},
	"BF-ZON": {}, "BF-ZOU": {}, "BG-01": {}, "BG-02": {}, "BG-03": {},
	"BG-04": {}, "BG-05": {}, "BG-06": {}, "BG-07": {}, "BG-08": {},
	"BG-09": {}, "BG-10": {}, "BG-11": {}, "BG-12": {}, "BG-13": {},
	"BG-14": {}, "BG-15": {}, "BG-16": {}, "BG-17": {}, "BG-18": {},
	"BG-19": {}, "BG-20": {}, "BG-21": {}, "BG-22": {}, "BG-23": {},
	"BG-24": {}, "BG-25": {}, "BG-26": {}, "BG-27": {}, "BG-28": {},
	"BH-13": {}, "BH-14": {}, "BH-15": {}, "BH-16": {}, "BH-17": {},
	"BI-BB": {}, "BI-BL": {}, "BI-BM": {}, "BI-BR": {}, "BI-CA": {},
	"BI-CI": {}, "BI-GI": {}, "BI-KI": {}, "BI-KR": {}, "BI-KY": {},
	"BI-MA": {}, "BI-MU": {}, "BI-MW": {}, "BI-NG": {}, "BI-RM": {}, "BI-RT": {},
	"BI-RY": {}, "BJ-AK": {}, "BJ-AL": {}, "BJ-AQ": {}, "BJ-BO": {},
	"BJ-CO": {}, "BJ-DO": {}, "BJ-KO": {}, "BJ-LI": {}, "BJ-MO": {},
	"BJ-OU": {}, "BJ-PL": {}, "BJ-ZO": {}, "BN-BE": {}, "BN-BM": {},
	"BN-TE": {}, "BN-TU": {}, "BO-B": {}, "BO-C": {}, "BO-H": {},
	"BO-L": {}, "BO-N": {}, "BO-O": {}, "BO-P": {}, "BO-S": {},
	"BO-T": {}, "BQ-BO": {}, "BQ-SA": {}, "BQ-SE": {}, "BR-AC": {},
	"BR-AL": {}, "BR-AM": {}, "BR-AP": {}, "BR-BA": {}, "BR-CE": {},
	"BR-DF": {}, "BR-ES": {}, "BR-FN": {}, "BR-GO": {}, "BR-MA": {},
	"BR-MG": {}, "BR-MS": {}, "BR-MT": {}, "BR-PA": {}, "BR-PB": {},
	"BR-PE": {}, "BR-PI": {}, "BR-PR": {}, "BR-RJ": {}, "BR-RN": {},
	"BR-RO": {}, "BR-RR": {}, "BR-RS": {}, "BR-SC": {}, "BR-SE": {},
	"BR-SP": {}, "BR-TO": {}, "BS-AK": {}, "BS-BI": {}, "BS-BP": {},
	"BS-BY": {}, "BS-CE": {}, "BS-CI": {}, "BS-CK": {}, "BS-CO": {},
	"BS-CS": {}, "BS-EG": {}, "BS-EX": {}, "BS-FP": {}, "BS-GC": {},
	"BS-HI": {}, "BS-HT": {}, "BS-IN": {}, "BS-LI": {}, "BS-MC": {},
	"BS-MG": {}, "BS-MI": {}, "BS-NE": {}, "BS-NO": {}, "BS-NP": {}, "BS-NS": {},
	"BS-RC": {}, "BS-RI": {}, "BS-SA": {}, "BS-SE": {}, "BS-SO": {},
	"BS-SS": {}, "BS-SW": {}, "BS-WG": {}, "BT-11": {}, "BT-12": {},
	"BT-13": {}, "BT-14": {}, "BT-15": {}, "BT-21": {}, "BT-22": {},
	"BT-23": {}, "BT-24": {}, "BT-31": {}, "BT-32": {}, "BT-33": {},
	"BT-34": {}, "BT-41": {}, "BT-42": {}, "BT-43": {}, "BT-44": {},
	"BT-45": {}, "BT-GA": {}, "BT-TY": {}, "BW-CE": {}, "BW-CH": {}, "BW-GH": {},
	"BW-KG": {}, "BW-KL": {}, "BW-KW": {}, "BW-NE": {}, "BW-NW": {},
	"BW-SE": {}, "BW-SO": {}, "BY-BR": {}, "BY-HM": {}, "BY-HO": {},
	"BY-HR": {}, "BY-MA": {}, "BY-MI": {}, "BY-VI": {}, "BZ-BZ": {},
	"BZ-CY": {}, "BZ-CZL": {}, "BZ-OW": {}, "BZ-SC": {}, "BZ-TOL": {},
	"CA-AB": {}, "CA-BC": {}, "CA-MB": {}, "CA-NB": {}, "CA-NL": {},
	"CA-NS": {}, "CA-NT": {}, "CA-NU": {}, "CA-ON": {}, "CA-PE": {},
	"CA-QC": {}, "CA-SK": {}, "CA-YT": {}, "CD-BC": {}, "CD-BN": {},
	"CD-EQ": {}, "CD-HK": {}, "CD-IT": {}, "CD-KA": {}, "CD-KC": {}, "CD-KE": {}, "CD-KG": {}, "CD-KN": {},
	"CD-KW": {}, "CD-KS": {}, "CD-LU": {}, "CD-MA": {}, "CD-NK": {}, "CD-OR": {}, "CD-SA": {}, "CD-SK": {},
	"CD-TA": {}, "CD-TO": {}, "CF-AC": {}, "CF-BB": {}, "CF-BGF": {}, "CF-BK": {}, "CF-HK": {}, "CF-HM": {},
	"CF-HS": {}, "CF-KB": {}, "CF-KG": {}, "CF-LB": {}, "CF-MB": {},
	"CF-MP": {}, "CF-NM": {}, "CF-OP": {}, "CF-SE": {}, "CF-UK": {},
	"CF-VK": {}, "CG-11": {}, "CG-12": {}, "CG-13": {}, "CG-14": {},
	"CG-15": {}, "CG-16": {}, "CG-2": {}, "CG-5": {}, "CG-7": {}, "CG-8": {},
	"CG-9": {}, "CG-BZV": {}, "CH-AG": {}, "CH-AI": {}, "CH-AR": {},
	"CH-BE": {}, "CH-BL": {}, "CH-BS": {}, "CH-FR": {}, "CH-GE": {},
	"CH-GL": {}, "CH-GR": {}, "CH-JU": {}, "CH-LU": {}, "CH-NE": {},
	"CH-NW": {}, "CH-OW": {}, "CH-SG": {}, "CH-SH": {}, "CH-SO": {},
	"CH-SZ": {}, "CH-TG": {}, "CH-TI": {}, "CH-UR": {}, "CH-VD": {},
	"CH-VS": {}, "CH-ZG": {}, "CH-ZH": {}, "CI-AB": {}, "CI-BS": {},
	"CI-CM": {}, "CI-DN": {}, "CI-GD": {}, "CI-LC": {}, "CI-LG": {},
	"CI-MG": {}, "CI-SM": {}, "CI-SV": {}, "CI-VB": {}, "CI-WR": {},
	"CI-YM": {}, "CI-ZZ": {}, "CL-AI": {}, "CL-AN": {}, "CL-AP": {},
	"CL-AR": {}, "CL-AT": {}, "CL-BI": {}, "CL-CO": {}, "CL-LI": {},
	"CL-LL": {}, "CL-LR": {}, "CL-MA": {}, "CL-ML": {}, "CL-NB": {}, "CL-RM": {},
	"CL-TA": {}, "CL-VS": {}, "CM-AD": {}, "CM-CE": {}, "CM-EN": {},
	"CM-ES": {}, "CM-LT": {}, "CM-NO": {}, "CM-NW": {}, "CM-OU": {},
	"CM-SU": {}, "CM-SW": {}, "CN-AH": {}, "CN-BJ": {}, "CN-CQ": {},
	"CN-FJ": {}, "CN-GS": {}, "CN-GD": {}, "CN-GX": {}, "CN-GZ": {},
	"CN-HI": {}, "CN-HE": {}, "CN-HL": {}, "CN-HA": {}, "CN-HB": {},
	"CN-HN": {}, "CN-JS": {}, "CN-JX": {}, "CN-JL": {}, "CN-LN": {},
	"CN-NM": {}, "CN-NX": {}, "CN-QH": {}, "CN-SN": {}, "CN-SD": {}, "CN-SH": {},
	"CN-SX": {}, "CN-SC": {}, "CN-TJ": {}, "CN-XJ": {}, "CN-XZ": {}, "CN-YN": {},
	"CN-ZJ": {}, "CO-AMA": {}, "CO-ANT": {}, "CO-ARA": {}, "CO-ATL": {},
	"CO-BOL": {}, "CO-BOY": {}, "CO-CAL": {}, "CO-CAQ": {}, "CO-CAS": {},
	"CO-CAU": {}, "CO-CES": {}, "CO-CHO": {}, "CO-COR": {}, "CO-CUN": {},
	"CO-DC": {}, "CO-GUA": {}, "CO-GUV": {}, "CO-HUI": {}, "CO-LAG": {},
	"CO-MAG": {}, "CO-MET": {}, "CO-NAR": {}, "CO-NSA": {}, "CO-PUT": {},
	"CO-QUI": {}, "CO-RIS": {}, "CO-SAN": {}, "CO-SAP": {}, "CO-SUC": {},
	"CO-TOL": {}, "CO-VAC": {}, "CO-VAU": {}, "CO-VID": {}, "CR-A": {},
	"CR-C": {}, "CR-G": {}, "CR-H": {}, "CR-L": {}, "CR-P": {},
	"CR-SJ": {}, "CU-01": {}, "CU-02": {}, "CU-03": {}, "CU-04": {},
	"CU-05": {}, "CU-06": {}, "CU-07": {}, "CU-08": {}, "CU-09": {},
	"CU-10": {}, "CU-11": {}, "CU-12": {}, "CU-13": {}, "CU-14": {}, "CU-15": {},
	"CU-16": {}, "CU-99": {}, "CV-B": {}, "CV-BR": {}, "CV-BV": {}, "CV-CA": {},
	"CV-CF": {}, "CV-CR": {}, "CV-MA": {}, "CV-MO": {}, "CV-PA": {},
	"CV-PN": {}, "CV-PR": {}, "CV-RB": {}, "CV-RG": {}, "CV-RS": {},
	"CV-S": {}, "CV-SD": {}, "CV-SF": {}, "CV-SL": {}, "CV-SM": {},
	"CV-SO": {}, "CV-SS": {}, "CV-SV": {}, "CV-TA": {}, "CV-TS": {},
	"CY-01": {}, "CY-02": {}, "CY-03": {}, "CY-04": {}, "CY-05": {},
	"CY-06": {}, "CZ-10": {}, "CZ-101": {}, "CZ-102": {}, "CZ-103": {},
	"CZ-104": {}, "CZ-105": {}, "CZ-106": {}, "CZ-107": {}, "CZ-108": {},
	"CZ-109": {}, "CZ-110": {}, "CZ-111": {}, "CZ-112": {}, "CZ-113": {},
	"CZ-114": {}, "CZ-115": {}, "CZ-116": {}, "CZ-117": {}, "CZ-118": {},
	"CZ-119": {}, "CZ-120": {}, "CZ-121": {}, "CZ-122": {}, "CZ-20": {},
	"CZ-201": {}, "CZ-202": {}, "CZ-203": {}, "CZ-204": {}, "CZ-205": {},
	"CZ-206": {}, "CZ-207": {}, "CZ-208": {}, "CZ-209": {}, "CZ-20A": {},
	"CZ-20B": {}, "CZ-20C": {}, "CZ-31": {}, "CZ-311": {}, "CZ-312": {},
	"CZ-313": {}, "CZ-314": {}, "CZ-315": {}, "CZ-316": {}, "CZ-317": {},
	"CZ-32": {}, "CZ-321": {}, "CZ-322": {}, "CZ-323": {}, "CZ-324": {},
	"CZ-325": {}, "CZ-326": {}, "CZ-327": {}, "CZ-41": {}, "CZ-411": {},
	"CZ-412": {}, "CZ-413": {}, "CZ-42": {}, "CZ-421": {}, "CZ-422": {},
	"CZ-423": {}, "CZ-424": {}, "CZ-425": {}, "CZ-426": {}, "CZ-427": {},
	"CZ-51": {}, "CZ-511": {}, "CZ-512": {}, "CZ-513": {}, "CZ-514": {},
	"CZ-52": {}, "CZ-521": {}, "CZ-522": {}, "CZ-523": {}, "CZ-524": {},
	"CZ-525": {}, "CZ-53": {}, "CZ-531": {}, "CZ-532": {}, "CZ-533": {},
	"CZ-534": {}, "CZ-63": {}, "CZ-631": {}, "CZ-632": {}, "CZ-633": {},
	"CZ-634": {}, "CZ-635": {}, "CZ-64": {}, "CZ-641": {}, "CZ-642": {},
	"CZ-643": {}, "CZ-644": {}, "CZ-645": {}, "CZ-646": {}, "CZ-647": {},
	"CZ-71": {}, "CZ-711": {}, "CZ-712": {}, "CZ-713": {}, "CZ-714": {},
	"CZ-715": {}, "CZ-72": {}, "CZ-721": {}, "CZ-722": {}, "CZ-723": {},
	"CZ-724": {}, "CZ-80": {}, "CZ-801": {}, "CZ-802": {}, "CZ-803": {},
	"CZ-804": {}, "CZ-805": {}, "CZ-806": {}, "DE-BB": {}, "DE-BE": {},
	"DE-BW": {}, "DE-BY": {}, "DE-HB": {}, "DE-HE": {}, "DE-HH": {},
	"DE-MV": {}, "DE-NI": {}, "DE-NW": {}, "DE-RP": {}, "DE-SH": {},
	"DE-SL": {}, "DE-SN": {}, "DE-ST": {}, "DE-TH": {}, "DJ-AR": {},
	"DJ-AS": {}, "DJ-DI": {}, "DJ-DJ": {}, "DJ-OB": {}, "DJ-TA": {},
	"DK-81": {}, "DK-82": {}, "DK-83": {}, "DK-84": {}, "DK-85": {},
	"DM-01": {}, "DM-02": {}, "DM-03": {}, "DM-04": {}, "DM-05": {},
	"DM-06": {}, "DM-07": {}, "DM-08": {}, "DM-09": {}, "DM-10": {},
	"DO-01": {}, "DO-02": {}, "DO-03": {}, "DO-04": {}, "DO-05": {},
	"DO-06": {}, "DO-07": {}, "DO-08": {}, "DO-09": {}, "DO-10": {},
	"DO-11": {}, "DO-12": {}, "DO-13": {}, "DO-14": {}, "DO-15": {},
	"DO-16": {}, "DO-17": {}, "DO-18": {}, "DO-19": {}, "DO-20": {},
	"DO-21": {}, "DO-22": {}, "DO-23": {}, "DO-24": {}, "DO-25": {},
	"DO-26": {}, "DO-27": {}, "DO-28": {}, "DO-29": {}, "DO-30": {}, "DO-31": {},
	"DZ-01": {}, "DZ-02": {}, "DZ-03": {}, "DZ-04": {}, "DZ-05": {},
	"DZ-06": {}, "DZ-07": {}, "DZ-08": {}, "DZ-09": {}, "DZ-10": {},
	"DZ-11": {}, "DZ-12": {}, "DZ-13": {}, "DZ-14": {}, "DZ-15": {},
	"DZ-16": {}, "DZ-17": {}, "DZ-18": {}, "DZ-19": {}, "DZ-20": {},
	"DZ-21": {}, "DZ-22": {}, "DZ-23": {}, "DZ-24": {}, "DZ-25": {},
	"DZ-26": {}, "DZ-27": {}, "DZ-28": {}, "DZ-29": {}, "DZ-30": {},
	"DZ-31": {}, "DZ-32": {}, "DZ-33": {}, "DZ-34": {}, "DZ-35": {},
	"DZ-36": {}, "DZ-37": {}, "DZ-38": {}, "DZ-39": {}, "DZ-40": {},
	"DZ-41": {}, "DZ-42": {}, "DZ-43": {}, "DZ-44": {}, "DZ-45": {},
	"DZ-46": {}, "DZ-47": {}, "DZ-48": {}, "DZ-49": {}, "DZ-51": {},
	"DZ-53": {}, "DZ-55": {}, "DZ-56": {}, "DZ-57": {}, "EC-A": {}, "EC-B": {},
	"EC-C": {}, "EC-D": {}, "EC-E": {}, "EC-F": {}, "EC-G": {},
	"EC-H": {}, "EC-I": {}, "EC-L": {}, "EC-M": {}, "EC-N": {},
	"EC-O": {}, "EC-P": {}, "EC-R": {}, "EC-S": {}, "EC-SD": {},
	"EC-SE": {}, "EC-T": {}, "EC-U": {}, "EC-W": {}, "EC-X": {},
	"EC-Y": {}, "EC-Z": {}, "EE-37": {}, "EE-39": {}, "EE-44": {}, "EE-45": {},
	"EE-49": {}, "EE-50": {}, "EE-51": {}, "EE-52": {}, "EE-56": {}, "EE-57": {},
	"EE-59": {}, "EE-60": {}, "EE-64": {}, "EE-65": {}, "EE-67": {}, "EE-68": {},
	"EE-70": {}, "EE-71": {}, "EE-74": {}, "EE-78": {}, "EE-79": {}, "EE-81": {}, "EE-82": {},
	"EE-84": {}, "EE-86": {}, "EE-87": {}, "EG-ALX": {}, "EG-ASN": {}, "EG-AST": {},
	"EG-BA": {}, "EG-BH": {}, "EG-BNS": {}, "EG-C": {}, "EG-DK": {},
	"EG-DT": {}, "EG-FYM": {}, "EG-GH": {}, "EG-GZ": {}, "EG-HU": {},
	"EG-IS": {}, "EG-JS": {}, "EG-KB": {}, "EG-KFS": {}, "EG-KN": {},
	"EG-LX": {}, "EG-MN": {}, "EG-MNF": {}, "EG-MT": {}, "EG-PTS": {}, "EG-SHG": {},
	"EG-SHR": {}, "EG-SIN": {}, "EG-SU": {}, "EG-SUZ": {}, "EG-WAD": {},
	"ER-AN": {}, "ER-DK": {}, "ER-DU": {}, "ER-GB": {}, "ER-MA": {},
	"ER-SK": {}, "ES-A": {}, "ES-AB": {}, "ES-AL": {}, "ES-AN": {},
	"ES-AR": {}, "ES-AS": {}, "ES-AV": {}, "ES-B": {}, "ES-BA": {},
	"ES-BI": {}, "ES-BU": {}, "ES-C": {}, "ES-CA": {}, "ES-CB": {},
	"ES-CC": {}, "ES-CE": {}, "ES-CL": {}, "ES-CM": {}, "ES-CN": {},
	"ES-CO": {}, "ES-CR": {}, "ES-CS": {}, "ES-CT": {}, "ES-CU": {},
	"ES-EX": {}, "ES-GA": {}, "ES-GC": {}, "ES-GI": {}, "ES-GR": {},
	"ES-GU": {}, "ES-H": {}, "ES-HU": {}, "ES-IB": {}, "ES-J": {},
	"ES-L": {}, "ES-LE": {}, "ES-LO": {}, "ES-LU": {}, "ES-M": {},
	"ES-MA": {}, "ES-MC": {}, "ES-MD": {}, "ES-ML": {}, "ES-MU": {},
	"ES-NA": {}, "ES-NC": {}, "ES-O": {}, "ES-OR": {}, "ES-P": {},
	"ES-PM": {}, "ES-PO": {}, "ES-PV": {}, "ES-RI": {}, "ES-S": {},
	"ES-SA": {}, "ES-SE": {}, "ES-SG": {}, "ES-SO": {}, "ES-SS": {},
	"ES-T": {}, "ES-TE": {}, "ES-TF": {}, "ES-TO": {}, "ES-V": {},
	"ES-VA": {}, "ES-VC": {}, "ES-VI": {}, "ES-Z": {}, "ES-ZA": {},
	"ET-AA": {}, "ET-AF": {}, "ET-AM": {}, "ET-BE": {}, "ET-DD": {},
	"ET-GA": {}, "ET-HA": {}, "ET-OR": {}, "ET-SN": {}, "ET-SO": {},
	"ET-TI": {}, "FI-01": {}, "FI-02": {}, "FI-03": {}, "FI-04": {},
	"FI-05": {}, "FI-06": {}, "FI-07": {}, "FI-08": {}, "FI-09": {},
	"FI-10": {}, "FI-11": {}, "FI-12": {}, "FI-13": {}, "FI-14": {},
	"FI-15": {}, "FI-16": {}, "FI-17": {}, "FI-18": {}, "FI-19": {},
	"FJ-C": {}, "FJ-E": {}, "FJ-N": {}, "FJ-R": {}, "FJ-W": {},
	"FM-KSA": {}, "FM-PNI": {}, "FM-TRK": {}, "FM-YAP": {}, "FR-01": {},
	"FR-02": {}, "FR-03": {}, "FR-04": {}, "FR-05": {}, "FR-06": {},
	"FR-07": {}, "FR-08": {}, "FR-09": {}, "FR-10": {}, "FR-11": {},
	"FR-12": {}, "FR-13": {}, "FR-14": {}, "FR-15": {}, "FR-16": {},
	"FR-17": {}, "FR-18": {}, "FR-19": {}, "FR-20R": {}, "FR-21": {}, "FR-22": {},
	"FR-23": {}, "FR-24": {}, "FR-25": {}, "FR-26": {}, "FR-27": {},
	"FR-28": {}, "FR-29": {}, "FR-2A": {}, "FR-2B": {}, "FR-30": {},
	"FR-31": {}, "FR-32": {}, "FR-33": {}, "FR-34": {}, "FR-35": {},
	"FR-36": {}, "FR-37": {}, "FR-38": {}, "FR-39": {}, "FR-40": {},
	"FR-41": {}, "FR-42": {}, "FR-43": {}, "FR-44": {}, "FR-45": {},
	"FR-46": {}, "FR-47": {}, "FR-48": {}, "FR-49": {}, "FR-50": {},
	"FR-51": {}, "FR-52": {}, "FR-53": {}, "FR-54": {}, "FR-55": {},
	"FR-56": {}, "FR-57": {}, "FR-58": {}, "FR-59": {}, "FR-60": {},
	"FR-61": {}, "FR-62": {}, "FR-63": {}, "FR-64": {}, "FR-65": {},
	"FR-66": {}, "FR-67": {}, "FR-68": {}, "FR-69": {}, "FR-70": {},
	"FR-71": {}, "FR-72": {}, "FR-73": {}, "FR-74": {}, "FR-75": {},
	"FR-76": {}, "FR-77": {}, "FR-78": {}, "FR-79": {}, "FR-80": {},
	"FR-81": {}, "FR-82": {}, "FR-83": {}, "FR-84": {}, "FR-85": {},
	"FR-86": {}, "FR-87": {}, "FR-88": {}, "FR-89": {}, "FR-90": {},
	"FR-91": {}, "FR-92": {}, "FR-93": {}, "FR-94": {}, "FR-95": {},
	"FR-ARA": {}, "FR-BFC": {}, "FR-BL": {}, "FR-BRE": {}, "FR-COR": {},
	"FR-CP": {}, "FR-CVL": {}, "FR-GES": {}, "FR-GF": {}, "FR-GP": {},
	"FR-GUA": {}, "FR-HDF": {}, "FR-IDF": {}, "FR-LRE": {}, "FR-MAY": {},
	"FR-MF": {}, "FR-MQ": {}, "FR-NAQ": {}, "FR-NC": {}, "FR-NOR": {},
	"FR-OCC": {}, "FR-PAC": {}, "FR-PDL": {}, "FR-PF": {}, "FR-PM": {},
	"FR-RE": {}, "FR-TF": {}, "FR-WF": {}, "FR-YT": {}, "GA-1": {},
	"GA-2": {}, "GA-3": {}, "GA-4": {}, "GA-5": {}, "GA-6": {},
	"GA-7": {}, "GA-8": {}, "GA-9": {}, "GB-ABC": {}, "GB-ABD": {},
	"GB-ABE": {}, "GB-AGB": {}, "GB-AGY": {}, "GB-AND": {}, "GB-ANN": {},
	"GB-ANS": {}, "GB-BAS": {}, "GB-BBD": {}, "GB-BDF": {}, "GB-BDG": {},
	"GB-BEN": {}, "GB-BEX": {}, "GB-BFS": {}, "GB-BGE": {}, "GB-BGW": {},
	"GB-BIR": {}, "GB-BKM": {}, "GB-BMH": {}, "GB-BNE": {}, "GB-BNH": {},
	"GB-BNS": {}, "GB-BOL": {}, "GB-BPL": {}, "GB-BRC": {}, "GB-BRD": {},
	"GB-BRY": {}, "GB-BST": {}, "GB-BUR": {}, "GB-CAM": {}, "GB-CAY": {},
	"GB-CBF": {}, "GB-CCG": {}, "GB-CGN": {}, "GB-CHE": {}, "GB-CHW": {},
	"GB-CLD": {}, "GB-CLK": {}, "GB-CMA": {}, "GB-CMD": {}, "GB-CMN": {},
	"GB-CON": {}, "GB-COV": {}, "GB-CRF": {}, "GB-CRY": {}, "GB-CWY": {},
	"GB-DAL": {}, "GB-DBY": {}, "GB-DEN": {}, "GB-DER": {}, "GB-DEV": {},
	"GB-DGY": {}, "GB-DNC": {}, "GB-DND": {}, "GB-DOR": {}, "GB-DRS": {},
	"GB-DUD": {}, "GB-DUR": {}, "GB-EAL": {}, "GB-EAW": {}, "GB-EAY": {},
	"GB-EDH": {}, "GB-EDU": {}, "GB-ELN": {}, "GB-ELS": {}, "GB-ENF": {},
	"GB-ENG": {}, "GB-ERW": {}, "GB-ERY": {}, "GB-ESS": {}, "GB-ESX": {},
	"GB-FAL": {}, "GB-FIF": {}, "GB-FLN": {}, "GB-FMO": {}, "GB-GAT": {},
	"GB-GBN": {}, "GB-GLG": {}, "GB-GLS": {}, "GB-GRE": {}, "GB-GWN": {},
	"GB-HAL": {}, "GB-HAM": {}, "GB-HAV": {}, "GB-HCK": {}, "GB-HEF": {},
	"GB-HIL": {}, "GB-HLD": {}, "GB-HMF": {}, "GB-HNS": {}, "GB-HPL": {},
	"GB-HRT": {}, "GB-HRW": {}, "GB-HRY": {}, "GB-IOS": {}, "GB-IOW": {},
	"GB-ISL": {}, "GB-IVC": {}, "GB-KEC": {}, "GB-KEN": {}, "GB-KHL": {},
	"GB-KIR": {}, "GB-KTT": {}, "GB-KWL": {}, "GB-LAN": {}, "GB-LBC": {},
	"GB-LBH": {}, "GB-LCE": {}, "GB-LDS": {}, "GB-LEC": {}, "GB-LEW": {},
	"GB-LIN": {}, "GB-LIV": {}, "GB-LND": {}, "GB-LUT": {}, "GB-MAN": {},
	"GB-MDB": {}, "GB-MDW": {}, "GB-MEA": {}, "GB-MIK": {}, "GD-01": {},
	"GB-MLN": {}, "GB-MON": {}, "GB-MRT": {}, "GB-MRY": {}, "GB-MTY": {},
	"GB-MUL": {}, "GB-NAY": {}, "GB-NBL": {}, "GB-NEL": {}, "GB-NET": {},
	"GB-NFK": {}, "GB-NGM": {}, "GB-NIR": {}, "GB-NLK": {}, "GB-NLN": {},
	"GB-NMD": {}, "GB-NSM": {}, "GB-NTH": {}, "GB-NTL": {}, "GB-NTT": {},
	"GB-NTY": {}, "GB-NWM": {}, "GB-NWP": {}, "GB-NYK": {}, "GB-OLD": {},
	"GB-ORK": {}, "GB-OXF": {}, "GB-PEM": {}, "GB-PKN": {}, "GB-PLY": {},
	"GB-POL": {}, "GB-POR": {}, "GB-POW": {}, "GB-PTE": {}, "GB-RCC": {},
	"GB-RCH": {}, "GB-RCT": {}, "GB-RDB": {}, "GB-RDG": {}, "GB-RFW": {},
	"GB-RIC": {}, "GB-ROT": {}, "GB-RUT": {}, "GB-SAW": {}, "GB-SAY": {},
	"GB-SCB": {}, "GB-SCT": {}, "GB-SFK": {}, "GB-SFT": {}, "GB-SGC": {},
	"GB-SHF": {}, "GB-SHN": {}, "GB-SHR": {}, "GB-SKP": {}, "GB-SLF": {},
	"GB-SLG": {}, "GB-SLK": {}, "GB-SND": {}, "GB-SOL": {}, "GB-SOM": {},
	"GB-SOS": {}, "GB-SRY": {}, "GB-STE": {}, "GB-STG": {}, "GB-STH": {},
	"GB-STN": {}, "GB-STS": {}, "GB-STT": {}, "GB-STY": {}, "GB-SWA": {},
	"GB-SWD": {}, "GB-SWK": {}, "GB-TAM": {}, "GB-TFW": {}, "GB-THR": {},
	"GB-TOB": {}, "GB-TOF": {}, "GB-TRF": {}, "GB-TWH": {}, "GB-UKM": {},
	"GB-VGL": {}, "GB-WAR": {}, "GB-WBK": {}, "GB-WDU": {}, "GB-WFT": {},
	"GB-WGN": {}, "GB-WIL": {}, "GB-WKF": {}, "GB-WLL": {}, "GB-WLN": {},
	"GB-WLS": {}, "GB-WLV": {}, "GB-WND": {}, "GB-WNM": {}, "GB-WOK": {},
	"GB-WOR": {}, "GB-WRL": {}, "GB-WRT": {}, "GB-WRX": {}, "GB-WSM": {},
	"GB-WSX": {}, "GB-YOR": {}, "GB-ZET": {}, "GD-02": {}, "GD-03": {},
	"GD-04": {}, "GD-05": {}, "GD-06": {}, "GD-10": {}, "GE-AB": {},
	"GE-AJ": {}, "GE-GU": {}, "GE-IM": {}, "GE-KA": {}, "GE-KK": {},
	"GE-MM": {}, "GE-RL": {}, "GE-SJ": {}, "GE-SK": {}, "GE-SZ": {},
	"GE-TB": {}, "GH-AA": {}, "GH-AH": {}, "GH-AF": {}, "GH-BA": {}, "GH-BO": {}, "GH-BE": {}, "GH-CP": {},
	"GH-EP": {}, "GH-NP": {}, "GH-TV": {}, "GH-UE": {}, "GH-UW": {},
	"GH-WP": {}, "GL-AV": {}, "GL-KU": {}, "GL-QA": {}, "GL-QT": {}, "GL-QE": {}, "GL-SM": {},
	"GM-B": {}, "GM-L": {}, "GM-M": {}, "GM-N": {}, "GM-U": {},
	"GM-W": {}, "GN-B": {}, "GN-BE": {}, "GN-BF": {}, "GN-BK": {},
	"GN-C": {}, "GN-CO": {}, "GN-D": {}, "GN-DB": {}, "GN-DI": {},
	"GN-DL": {}, "GN-DU": {}, "GN-F": {}, "GN-FA": {}, "GN-FO": {},
	"GN-FR": {}, "GN-GA": {}, "GN-GU": {}, "GN-K": {}, "GN-KA": {},
	"GN-KB": {}, "GN-KD": {}, "GN-KE": {}, "GN-KN": {}, "GN-KO": {},
	"GN-KS": {}, "GN-L": {}, "GN-LA": {}, "GN-LE": {}, "GN-LO": {},
	"GN-M": {}, "GN-MC": {}, "GN-MD": {}, "GN-ML": {}, "GN-MM": {},
	"GN-N": {}, "GN-NZ": {}, "GN-PI": {}, "GN-SI": {}, "GN-TE": {},
	"GN-TO": {}, "GN-YO": {}, "GQ-AN": {}, "GQ-BN": {}, "GQ-BS": {},
	"GQ-C": {}, "GQ-CS": {}, "GQ-I": {}, "GQ-KN": {}, "GQ-LI": {},
	"GQ-WN": {}, "GR-01": {}, "GR-03": {}, "GR-04": {}, "GR-05": {},
	"GR-06": {}, "GR-07": {}, "GR-11": {}, "GR-12": {}, "GR-13": {},
	"GR-14": {}, "GR-15": {}, "GR-16": {}, "GR-17": {}, "GR-21": {},
	"GR-22": {}, "GR-23": {}, "GR-24": {}, "GR-31": {}, "GR-32": {},
	"GR-33": {}, "GR-34": {}, "GR-41": {}, "GR-42": {}, "GR-43": {},
	"GR-44": {}, "GR-51": {}, "GR-52": {}, "GR-53": {}, "GR-54": {},
	"GR-55": {}, "GR-56": {}, "GR-57": {}, "GR-58": {}, "GR-59": {},
	"GR-61": {}, "GR-62": {}, "GR-63": {}, "GR-64": {}, "GR-69": {},
	"GR-71": {}, "GR-72": {}, "GR-73": {}, "GR-81": {}, "GR-82": {},
	"GR-83": {}, "GR-84": {}, "GR-85": {}, "GR-91": {}, "GR-92": {},
	"GR-93": {}, "GR-94": {}, "GR-A": {}, "GR-A1": {}, "GR-B": {},
	"GR-C": {}, "GR-D": {}, "GR-E": {}, "GR-F": {}, "GR-G": {},
	"GR-H": {}, "GR-I": {}, "GR-J": {}, "GR-K": {}, "GR-L": {},
	"GR-M": {}, "GT-01": {}, "GT-02": {}, "GT-03": {}, "GT-04": {},
	"GT-05": {}, "GT-06": {}, "GT-07": {}, "GT-08": {}, "GT-09": {},
	"GT-10": {}, "GT-11": {}, "GT-12": {}, "GT-13": {}, "GT-14": {},
	"GT-15": {}, "GT-16": {}, "GT-17": {}, "GT-18": {}, "GT-19": {},
	"GT-20": {}, "GT-21": {}, "GT-22": {}, "GW-BA": {}, "GW-BL": {},
	"GW-BM": {}, "GW-BS": {}, "GW-CA": {}, "GW-GA": {}, "GW-L": {},
	"GW-N": {}, "GW-OI": {}, "GW-QU": {}, "GW-S": {}, "GW-TO": {},
	"GY-BA": {}, "GY-CU": {}, "GY-DE": {}, "GY-EB": {}, "GY-ES": {},
	"GY-MA": {}, "GY-PM": {}, "GY-PT": {}, "GY-UD": {}, "GY-UT": {},
	"HN-AT": {}, "HN-CH": {}, "HN-CL": {}, "HN-CM": {}, "HN-CP": {},
	"HN-CR": {}, "HN-EP": {}, "HN-FM": {}, "HN-GD": {}, "HN-IB": {},
	"HN-IN": {}, "HN-LE": {}, "HN-LP": {}, "HN-OC": {}, "HN-OL": {},
	"HN-SB": {}, "HN-VA": {}, "HN-YO": {}, "HR-01": {}, "HR-02": {},
	"HR-03": {}, "HR-04": {}, "HR-05": {}, "HR-06": {}, "HR-07": {},
	"HR-08": {}, "HR-09": {}, "HR-10": {}, "HR-11": {}, "HR-12": {},
	"HR-13": {}, "HR-14": {}, "HR-15": {}, "HR-16": {}, "HR-17": {},
	"HR-18": {}, "HR-19": {}, "HR-20": {}, "HR-21": {}, "HT-AR": {},
	"HT-CE": {}, "HT-GA": {}, "HT-ND": {}, "HT-NE": {}, "HT-NO": {}, "HT-NI": {},
	"HT-OU": {}, "HT-SD": {}, "HT-SE": {}, "HU-BA": {}, "HU-BC": {},
	"HU-BE": {}, "HU-BK": {}, "HU-BU": {}, "HU-BZ": {}, "HU-CS": {},
	"HU-DE": {}, "HU-DU": {}, "HU-EG": {}, "HU-ER": {}, "HU-FE": {},
	"HU-GS": {}, "HU-GY": {}, "HU-HB": {}, "HU-HE": {}, "HU-HV": {},
	"HU-JN": {}, "HU-KE": {}, "HU-KM": {}, "HU-KV": {}, "HU-MI": {},
	"HU-NK": {}, "HU-NO": {}, "HU-NY": {}, "HU-PE": {}, "HU-PS": {},
	"HU-SD": {}, "HU-SF": {}, "HU-SH": {}, "HU-SK": {}, "HU-SN": {},
	"HU-SO": {}, "HU-SS": {}, "HU-ST": {}, "HU-SZ": {}, "HU-TB": {},
	"HU-TO": {}, "HU-VA": {}, "HU-VE": {}, "HU-VM": {}, "HU-ZA": {},
	"HU-ZE": {}, "ID-AC": {}, "ID-BA": {}, "ID-BB": {}, "ID-BE": {},
	"ID-BT": {}, "ID-GO": {}, "ID-IJ": {}, "ID-JA": {}, "ID-JB": {},
	"ID-JI": {}, "ID-JK": {}, "ID-JT": {}, "ID-JW": {}, "ID-KA": {},
	"ID-KB": {}, "ID-KI": {}, "ID-KU": {}, "ID-KR": {}, "ID-KS": {},
	"ID-KT": {}, "ID-LA": {}, "ID-MA": {}, "ID-ML": {}, "ID-MU": {},
	"ID-NB": {}, "ID-NT": {}, "ID-NU": {}, "ID-PA": {}, "ID-PB": {},
	"ID-PE": {}, "ID-PP": {}, "ID-PS": {}, "ID-PT": {}, "ID-RI": {},
	"ID-SA": {}, "ID-SB": {}, "ID-SG": {}, "ID-SL": {}, "ID-SM": {},
	"ID-SN": {}, "ID-SR": {}, "ID-SS": {}, "ID-ST": {}, "ID-SU": {},
	"ID-YO": {}, "IE-C": {}, "IE-CE": {}, "IE-CN": {}, "IE-CO": {},
	"IE-CW": {}, "IE-D": {}, "IE-DL": {}, "IE-G": {}, "IE-KE": {},
	"IE-KK": {}, "IE-KY": {}, "IE-L": {}, "IE-LD": {}, "IE-LH": {},
	"IE-LK": {}, "IE-LM": {}, "IE-LS": {}, "IE-M": {}, "IE-MH": {},
	"IE-MN": {}, "IE-MO": {}, "IE-OY": {}, "IE-RN": {}, "IE-SO": {},
	"IE-TA": {}, "IE-U": {}, "IE-WD": {}, "IE-WH": {}, "IE-WW": {},
	"IE-WX": {}, "IL-D": {}, "IL-HA": {}, "IL-JM": {}, "IL-M": {},
	"IL-TA": {}, "IL-Z": {}, "IN-AN": {}, "IN-AP": {}, "IN-AR": {},
	"IN-AS": {}, "IN-BR": {}, "IN-CH": {}, "IN-CT": {}, "IN-DH": {},
	"IN-DL": {}, "IN-DN": {}, "IN-GA": {}, "IN-GJ": {}, "IN-HP": {},
	"IN-HR": {}, "IN-JH": {}, "IN-JK": {}, "IN-KA": {}, "IN-KL": {},
	"IN-LD": {}, "IN-MH": {}, "IN-ML": {}, "IN-MN": {}, "IN-MP": {},
	"IN-MZ": {}, "IN-NL": {}, "IN-TG": {}, "IN-OR": {}, "IN-PB": {}, "IN-PY": {},
	"IN-RJ": {}, "IN-SK": {}, "IN-TN": {}, "IN-TR": {}, "IN-UP": {},
	"IN-UT": {}, "IN-WB": {}, "IQ-AN": {}, "IQ-AR": {}, "IQ-BA": {},
	"IQ-BB": {}, "IQ-BG": {}, "IQ-DA": {}, "IQ-DI": {}, "IQ-DQ": {},
	"IQ-KA": {}, "IQ-KI": {}, "IQ-MA": {}, "IQ-MU": {}, "IQ-NA": {}, "IQ-NI": {},
	"IQ-QA": {}, "IQ-SD": {}, "IQ-SW": {}, "IQ-SU": {}, "IQ-TS": {}, "IQ-WA": {},
	"IR-00": {}, "IR-01": {}, "IR-02": {}, "IR-03": {}, "IR-04": {}, "IR-05": {},
	"IR-06": {}, "IR-07": {}, "IR-08": {}, "IR-09": {}, "IR-10": {}, "IR-11": {},
	"IR-12": {}, "IR-13": {}, "IR-14": {}, "IR-15": {}, "IR-16": {},
	"IR-17": {}, "IR-18": {}, "IR-19": {}, "IR-20": {}, "IR-21": {},
	"IR-22": {}, "IR-23": {}, "IR-24": {}, "IR-25": {}, "IR-26": {},
	"IR-27": {}, "IR-28": {}, "IR-29": {}, "IR-30": {}, "IR-31": {},
	"IS-0": {}, "IS-1": {}, "IS-2": {}, "IS-3": {}, "IS-4": {},
	"IS-5": {}, "IS-6": {}, "IS-7": {}, "IS-8": {}, "IT-21": {},
	"IT-23": {}, "IT-25": {}, "IT-32": {}, "IT-34": {}, "IT-36": {},
	"IT-42": {}, "IT-45": {}, "IT-52": {}, "IT-55": {}, "IT-57": {},
	"IT-62": {}, "IT-65": {}, "IT-67": {}, "IT-72": {}, "IT-75": {},
	"IT-77": {}, "IT-78": {}, "IT-82": {}, "IT-88": {}, "IT-AG": {},
	"IT-AL": {}, "IT-AN": {}, "IT-AO": {}, "IT-AP": {}, "IT-AQ": {},
	"IT-AR": {}, "IT-AT": {}, "IT-AV": {}, "IT-BA": {}, "IT-BG": {},
	"IT-BI": {}, "IT-BL": {}, "IT-BN": {}, "IT-BO": {}, "IT-BR": {},
	"IT-BS": {}, "IT-BT": {}, "IT-BZ": {}, "IT-CA": {}, "IT-CB": {},
	"IT-CE": {}, "IT-CH": {}, "IT-CI": {}, "IT-CL": {}, "IT-CN": {},
	"IT-CO": {}, "IT-CR": {}, "IT-CS": {}, "IT-CT": {}, "IT-CZ": {},
	"IT-EN": {}, "IT-FC": {}, "IT-FE": {}, "IT-FG": {}, "IT-FI": {},
	"IT-FM": {}, "IT-FR": {}, "IT-GE": {}, "IT-GO": {}, "IT-GR": {},
	"IT-IM": {}, "IT-IS": {}, "IT-KR": {}, "IT-LC": {}, "IT-LE": {},
	"IT-LI": {}, "IT-LO": {}, "IT-LT": {}, "IT-LU": {}, "IT-MB": {},
	"IT-MC": {}, "IT-ME": {}, "IT-MI": {}, "IT-MN": {}, "IT-MO": {},
	"IT-MS": {}, "IT-MT": {}, "IT-NA": {}, "IT-NO": {}, "IT-NU": {},
	"IT-OG": {}, "IT-OR": {}, "IT-OT": {}, "IT-PA": {}, "IT-PC": {},
	"IT-PD": {}, "IT-PE": {}, "IT-PG": {}, "IT-PI": {}, "IT-PN": {},
	"IT-PO": {}, "IT-PR": {}, "IT-PT": {}, "IT-PU": {}, "IT-PV": {},
	"IT-PZ": {}, "IT-RA": {}, "IT-RC": {}, "IT-RE": {}, "IT-RG": {},
	"IT-RI": {}, "IT-RM": {}, "IT-RN": {}, "IT-RO": {}, "IT-SA": {},
	"IT-SI": {}, "IT-SO": {}, "IT-SP": {}, "IT-SR": {}, "IT-SS": {},
	"IT-SV": {}, "IT-TA": {}, "IT-TE": {}, "IT-TN": {}, "IT-TO": {},
	"IT-TP": {}, "IT-TR": {}, "IT-TS": {}, "IT-TV": {}, "IT-UD": {},
	"IT-VA": {}, "IT-VB": {}, "IT-VC": {}, "IT-VE": {}, "IT-VI": {},
	"IT-VR": {}, "IT-VS": {}, "IT-VT": {}, "IT-VV": {}, "JM-01": {},
	"JM-02": {}, "JM-03": {}, "JM-04": {}, "JM-05": {}, "JM-06": {},
	"JM-07": {}, "JM-08": {}, "JM-09": {}, "JM-10": {}, "JM-11": {},
	"JM-12": {}, "JM-13": {}, "JM-14": {}, "JO-AJ": {}, "JO-AM": {},
	"JO-AQ": {}, "JO-AT": {}, "JO-AZ": {}, "JO-BA": {}, "JO-IR": {},
	"JO-JA": {}, "JO-KA": {}, "JO-MA": {}, "JO-MD": {}, "JO-MN": {},
	"JP-01": {}, "JP-02": {}, "JP-03": {}, "JP-04": {}, "JP-05": {},
	"JP-06": {}, "JP-07": {}, "JP-08": {}, "JP-09": {}, "JP-10": {},
	"JP-11": {}, "JP-12": {}, "JP-13": {}, "JP-14": {}, "JP-15": {},
	"JP-16": {}, "JP-17": {}, "JP-18": {}, "JP-19": {}, "JP-20": {},
	"JP-21": {}, "JP-22": {}, "JP-23": {}, "JP-24": {}, "JP-25": {},
	"JP-26": {}, "JP-27": {}, "JP-28": {}, "JP-29": {}, "JP-30": {},
	"JP-31": {}, "JP-32": {}, "JP-33": {}, "JP-34": {}, "JP-35": {},
	"JP-36": {}, "JP-37": {}, "JP-38": {}, "JP-39": {}, "JP-40": {},
	"JP-41": {}, "JP-42": {}, "JP-43": {}, "JP-44": {}, "JP-45": {},
	"JP-46": {}, "JP-47": {}, "KE-01": {}, "KE-02": {}, "KE-03": {},
	"KE-04": {}, "KE-05": {}, "KE-06": {}, "KE-07": {}, "KE-08": {},
	"KE-09": {}, "KE-10": {}, "KE-11": {}, "KE-12": {}, "KE-13": {},
	"KE-14": {}, "KE-15": {}, "KE-16": {}, "KE-17": {}, "KE-18": {},
	"KE-19": {}, "KE-20": {}, "KE-21": {}, "KE-22": {}, "KE-23": {},
	"KE-24": {}, "KE-25": {}, "KE-26": {}, "KE-27": {}, "KE-28": {},
	"KE-29": {}, "KE-30": {}, "KE-31": {}, "KE-32": {}, "KE-33": {},
	"KE-34": {}, "KE-35": {}, "KE-36": {}, "KE-37": {}, "KE-38": {},
	"KE-39": {}, "KE-40": {}, "KE-41": {}, "KE-42": {}, "KE-43": {},
	"KE-44": {}, "KE-45": {}, "KE-46": {}, "KE-47": {}, "KG-B": {},
	"KG-C": {}, "KG-GB": {}, "KG-GO": {}, "KG-J": {}, "KG-N": {}, "KG-O": {},
	"KG-T": {}, "KG-Y": {}, "KH-1": {}, "KH-10": {}, "KH-11": {},
	"KH-12": {}, "KH-13": {}, "KH-14": {}, "KH-15": {}, "KH-16": {},
	"KH-17": {}, "KH-18": {}, "KH-19": {}, "KH-2": {}, "KH-20": {},
	"KH-21": {}, "KH-22": {}, "KH-23": {}, "KH-24": {}, "KH-3": {},
	"KH-4": {}, "KH-5": {}, "KH-6": {}, "KH-7": {}, "KH-8": {},
	"KH-9": {}, "KI-G": {}, "KI-L": {}, "KI-P": {}, "KM-A": {},
	"KM-G": {}, "KM-M": {}, "KN-01": {}, "KN-02": {}, "KN-03": {},
	"KN-04": {}, "KN-05": {}, "KN-06": {}, "KN-07": {}, "KN-08": {},
	"KN-09": {}, "KN-10": {}, "KN-11": {}, "KN-12": {}, "KN-13": {},
	"KN-15": {}, "KN-K": {}, "KN-N": {}, "KP-01": {}, "KP-02": {},
	"KP-03": {}, "KP-04": {}, "KP-05": {}, "KP-06": {}, "KP-07": {},
	"KP-08": {}, "KP-09": {}, "KP-10": {}, "KP-13": {}, "KR-11": {},
	"KR-26": {}, "KR-27": {}, "KR-28": {}, "KR-29": {}, "KR-30": {},
	"KR-31": {}, "KR-41": {}, "KR-42": {}, "KR-43": {}, "KR-44": {},
	"KR-45": {}, "KR-46": {}, "KR-47": {}, "KR-48": {}, "KR-49": {},
	"KW-AH": {}, "KW-FA": {}, "KW-HA": {}, "KW-JA": {}, "KW-KU": {},
	"KW-MU": {}, "KZ-10": {}, "KZ-75": {}, "KZ-19": {}, "KZ-11": {},
	"KZ-15": {}, "KZ-71": {}, "KZ-23": {}, "KZ-27": {}, "KZ-47": {},
	"KZ-55": {}, "KZ-35": {}, "KZ-39": {}, "KZ-43": {}, "KZ-63": {},
	"KZ-79": {}, "KZ-59": {}, "KZ-61": {}, "KZ-62": {}, "KZ-31": {},
	"KZ-33": {}, "LA-AT": {}, "LA-BK": {}, "LA-BL": {},
	"LA-CH": {}, "LA-HO": {}, "LA-KH": {}, "LA-LM": {}, "LA-LP": {},
	"LA-OU": {}, "LA-PH": {}, "LA-SL": {}, "LA-SV": {}, "LA-VI": {},
	"LA-VT": {}, "LA-XA": {}, "LA-XE": {}, "LA-XI": {}, "LA-XS": {},
	"LB-AK": {}, "LB-AS": {}, "LB-BA": {}, "LB-BH": {}, "LB-BI": {},
	"LB-JA": {}, "LB-JL": {}, "LB-NA": {}, "LC-01": {}, "LC-02": {},
	"LC-03": {}, "LC-05": {}, "LC-06": {}, "LC-07": {}, "LC-08": {},
	"LC-10": {}, "LC-11": {}, "LI-01": {}, "LI-02": {},
	"LI-03": {}, "LI-04": {}, "LI-05": {}, "LI-06": {}, "LI-07": {},
	"LI-08": {}, "LI-09": {}, "LI-10": {}, "LI-11": {}, "LK-1": {},
	"LK-11": {}, "LK-12": {}, "LK-13": {}, "LK-2": {}, "LK-21": {},
	"LK-22": {}, "LK-23": {}, "LK-3": {}, "LK-31": {}, "LK-32": {},
	"LK-33": {}, "LK-4": {}, "LK-41": {}, "LK-42": {}, "LK-43": {},
	"LK-44": {}, "LK-45": {}, "LK-5": {}, "LK-51": {}, "LK-52": {},
	"LK-53": {}, "LK-6": {}, "LK-61": {}, "LK-62": {}, "LK-7": {},
	"LK-71": {}, "LK-72": {}, "LK-8": {}, "LK-81": {}, "LK-82": {},
	"LK-9": {}, "LK-91": {}, "LK-92": {}, "LR-BG": {}, "LR-BM": {},
	"LR-CM": {}, "LR-GB": {}, "LR-GG": {}, "LR-GK": {}, "LR-LO": {},
	"LR-MG": {}, "LR-MO": {}, "LR-MY": {}, "LR-NI": {}, "LR-RI": {},
	"LR-SI": {}, "LS-A": {}, "LS-B": {}, "LS-C": {}, "LS-D": {},
	"LS-E": {}, "LS-F": {}, "LS-G": {}, "LS-H": {}, "LS-J": {},
	"LS-K": {}, "LT-AL": {}, "LT-KL": {}, "LT-KU": {}, "LT-MR": {},
	"LT-PN": {}, "LT-SA": {}, "LT-TA": {}, "LT-TE": {}, "LT-UT": {},
	"LT-VL": {}, "LU-CA": {}, "LU-CL": {}, "LU-DI": {}, "LU-EC": {},
	"LU-ES": {}, "LU-GR": {}, "LU-LU": {}, "LU-ME": {}, "LU-RD": {},
	"LU-RM": {}, "LU-VD": {}, "LU-WI": {}, "LU-D": {}, "LU-G": {}, "LU-L": {},
	"LV-001": {}, "LV-111": {}, "LV-112": {}, "LV-113": {},
	"LV-002": {}, "LV-003": {}, "LV-004": {}, "LV-005": {}, "LV-006": {},
	"LV-007": {}, "LV-008": {}, "LV-009": {}, "LV-010": {}, "LV-011": {},
	"LV-012": {}, "LV-013": {}, "LV-014": {}, "LV-015": {}, "LV-016": {},
	"LV-017": {}, "LV-018": {}, "LV-019": {}, "LV-020": {}, "LV-021": {},
	"LV-022": {}, "LV-023": {}, "LV-024": {}, "LV-025": {}, "LV-026": {},
	"LV-027": {}, "LV-028": {}, "LV-029": {}, "LV-030": {}, "LV-031": {},
	"LV-032": {}, "LV-033": {}, "LV-034": {}, "LV-035": {}, "LV-036": {},
	"LV-037": {}, "LV-038": {}, "LV-039": {}, "LV-040": {}, "LV-041": {},
	"LV-042": {}, "LV-043": {}, "LV-044": {}, "LV-045": {}, "LV-046": {},
	"LV-047": {}, "LV-048": {}, "LV-049": {}, "LV-050": {}, "LV-051": {},
	"LV-052": {}, "LV-053": {}, "LV-054": {}, "LV-055": {}, "LV-056": {},
	"LV-057": {}, "LV-058": {}, "LV-059": {}, "LV-060": {}, "LV-061": {},
	"LV-062": {}, "LV-063": {}, "LV-064": {}, "LV-065": {}, "LV-066": {},
	"LV-067": {}, "LV-068": {}, "LV-069": {}, "LV-070": {}, "LV-071": {},
	"LV-072": {}, "LV-073": {}, "LV-074": {}, "LV-075": {}, "LV-076": {},
	"LV-077": {}, "LV-078": {}, "LV-079": {}, "LV-080": {}, "LV-081": {},
	"LV-082": {}, "LV-083": {}, "LV-084": {}, "LV-085": {}, "LV-086": {},
	"LV-087": {}, "LV-088": {}, "LV-089": {}, "LV-090": {}, "LV-091": {},
	"LV-092": {}, "LV-093": {}, "LV-094": {}, "LV-095": {}, "LV-096": {},
	"LV-097": {}, "LV-098": {}, "LV-099": {}, "LV-100": {}, "LV-101": {},
	"LV-102": {}, "LV-103": {}, "LV-104": {}, "LV-105": {}, "LV-106": {},
	"LV-107": {}, "LV-108": {}, "LV-109": {}, "LV-110": {}, "LV-DGV": {},
	"LV-JEL": {}, "LV-JKB": {}, "LV-JUR": {}, "LV-LPX": {}, "LV-REZ": {},
	"LV-RIX": {}, "LV-VEN": {}, "LV-VMR": {}, "LY-BA": {}, "LY-BU": {},
	"LY-DR": {}, "LY-GT": {}, "LY-JA": {}, "LY-JB": {}, "LY-JG": {},
	"LY-JI": {}, "LY-JU": {}, "LY-KF": {}, "LY-MB": {}, "LY-MI": {},
	"LY-MJ": {}, "LY-MQ": {}, "LY-NL": {}, "LY-NQ": {}, "LY-SB": {},
	"LY-SR": {}, "LY-TB": {}, "LY-WA": {}, "LY-WD": {}, "LY-WS": {},
	"LY-ZA": {}, "MA-01": {}, "MA-02": {}, "MA-03": {}, "MA-04": {},
	"MA-05": {}, "MA-06": {}, "MA-07": {}, "MA-08": {}, "MA-09": {},
	"MA-10": {}, "MA-11": {}, "MA-12": {}, "MA-13": {}, "MA-14": {},
	"MA-15": {}, "MA-16": {}, "MA-AGD": {}, "MA-AOU": {}, "MA-ASZ": {},
	"MA-AZI": {}, "MA-BEM": {}, "MA-BER": {}, "MA-BES": {}, "MA-BOD": {},
	"MA-BOM": {}, "MA-CAS": {}, "MA-CHE": {}, "MA-CHI": {}, "MA-CHT": {},
	"MA-ERR": {}, "MA-ESI": {}, "MA-ESM": {}, "MA-FAH": {}, "MA-FES": {},
	"MA-FIG": {}, "MA-GUE": {}, "MA-HAJ": {}, "MA-HAO": {}, "MA-HOC": {},
	"MA-IFR": {}, "MA-INE": {}, "MA-JDI": {}, "MA-JRA": {}, "MA-KEN": {},
	"MA-KES": {}, "MA-KHE": {}, "MA-KHN": {}, "MA-KHO": {}, "MA-LAA": {},
	"MA-LAR": {}, "MA-MED": {}, "MA-MEK": {}, "MA-MMD": {}, "MA-MMN": {},
	"MA-MOH": {}, "MA-MOU": {}, "MA-NAD": {}, "MA-NOU": {}, "MA-OUA": {},
	"MA-OUD": {}, "MA-OUJ": {}, "MA-RAB": {}, "MA-SAF": {}, "MA-SAL": {},
	"MA-SEF": {}, "MA-SET": {}, "MA-SIK": {}, "MA-SKH": {}, "MA-SYB": {},
	"MA-TAI": {}, "MA-TAO": {}, "MA-TAR": {}, "MA-TAT": {}, "MA-TAZ": {},
	"MA-TET": {}, "MA-TIZ": {}, "MA-TNG": {}, "MA-TNT": {}, "MA-ZAG": {},
	"MC-CL": {}, "MC-CO": {}, "MC-FO": {}, "MC-GA": {}, "MC-JE": {},
	"MC-LA": {}, "MC-MA": {}, "MC-MC": {}, "MC-MG": {}, "MC-MO": {},
	"MC-MU": {}, "MC-PH": {}, "MC-SD": {}, "MC-SO": {}, "MC-SP": {},
	"MC-SR": {}, "MC-VR": {}, "MD-AN": {}, "MD-BA": {}, "MD-BD": {},
	"MD-BR": {}, "MD-BS": {}, "MD-CA": {}, "MD-CL": {}, "MD-CM": {},
	"MD-CR": {}, "MD-CS": {}, "MD-CT": {}, "MD-CU": {}, "MD-DO": {},
	"MD-DR": {}, "MD-DU": {}, "MD-ED": {}, "MD-FA": {}, "MD-FL": {},
	"MD-GA": {}, "MD-GL": {}, "MD-HI": {}, "MD-IA": {}, "MD-LE": {},
	"MD-NI": {}, "MD-OC": {}, "MD-OR": {}, "MD-RE": {}, "MD-RI": {},
	"MD-SD": {}, "MD-SI": {}, "MD-SN": {}, "MD-SO": {}, "MD-ST": {},
	"MD-SV": {}, "MD-TA": {}, "MD-TE": {}, "MD-UN": {}, "ME-01": {},
	"ME-02": {}, "ME-03": {}, "ME-04": {}, "ME-05": {}, "ME-06": {},
	"ME-07": {}, "ME-08": {}, "ME-09": {}, "ME-10": {}, "ME-11": {},
	"ME-12": {}, "ME-13": {}, "ME-14": {}, "ME-15": {}, "ME-16": {},
	"ME-17": {}, "ME-18": {}, "ME-19": {}, "ME-20": {}, "ME-21": {}, "ME-24": {},
	"MG-A": {}, "MG-D": {}, "MG-F": {}, "MG-M": {}, "MG-T": {},
	"MG-U": {}, "MH-ALK": {}, "MH-ALL": {}, "MH-ARN": {}, "MH-AUR": {},
	"MH-EBO": {}, "MH-ENI": {}, "MH-JAB": {}, "MH-JAL": {}, "MH-KIL": {},
	"MH-KWA": {}, "MH-L": {}, "MH-LAE": {}, "MH-LIB": {}, "MH-LIK": {},
	"MH-MAJ": {}, "MH-MAL": {}, "MH-MEJ": {}, "MH-MIL": {}, "MH-NMK": {},
	"MH-NMU": {}, "MH-RON": {}, "MH-T": {}, "MH-UJA": {}, "MH-UTI": {},
	"MH-WTJ": {}, "MH-WTN": {}, "MK-101": {}, "MK-102": {}, "MK-103": {},
	"MK-104": {}, "MK-105": {},
	"MK-106": {}, "MK-107": {}, "MK-108": {}, "MK-109": {}, "MK-201": {},
	"MK-202": {}, "MK-205": {}, "MK-206": {}, "MK-207": {}, "MK-208": {},
	"MK-209": {}, "MK-210": {}, "MK-211": {}, "MK-301": {}, "MK-303": {},
	"MK-307": {}, "MK-308": {}, "MK-310": {}, "MK-311": {}, "MK-312": {},
	"MK-401": {}, "MK-402": {}, "MK-403": {}, "MK-404": {}, "MK-405": {},
	"MK-406": {}, "MK-408": {}, "MK-409": {}, "MK-410": {}, "MK-501": {},
	"MK-502": {}, "MK-503": {}, "MK-505": {}, "MK-506": {}, "MK-507": {},
	"MK-508": {}, "MK-509": {}, "MK-601": {}, "MK-602": {}, "MK-604": {},
	"MK-605": {}, "MK-606": {}, "MK-607": {}, "MK-608": {}, "MK-609": {},
	"MK-701": {}, "MK-702": {}, "MK-703": {}, "MK-704": {}, "MK-705": {},
	"MK-803": {}, "MK-804": {}, "MK-806": {}, "MK-807": {}, "MK-809": {},
	"MK-810": {}, "MK-811": {}, "MK-812": {}, "MK-813": {}, "MK-814": {},
	"MK-816": {}, "ML-1": {}, "ML-2": {}, "ML-3": {}, "ML-4": {},
	"ML-5": {}, "ML-6": {}, "ML-7": {}, "ML-8": {}, "ML-BKO": {},
	"MM-01": {}, "MM-02": {}, "MM-03": {}, "MM-04": {}, "MM-05": {},
	"MM-06": {}, "MM-07": {}, "MM-11": {}, "MM-12": {}, "MM-13": {},
	"MM-14": {}, "MM-15": {}, "MM-16": {}, "MM-17": {}, "MM-18": {}, "MN-035": {},
	"MN-037": {}, "MN-039": {}, "MN-041": {}, "MN-043": {}, "MN-046": {},
	"MN-047": {}, "MN-049": {}, "MN-051": {}, "MN-053": {}, "MN-055": {},
	"MN-057": {}, "MN-059": {}, "MN-061": {}, "MN-063": {}, "MN-064": {},
	"MN-065": {}, "MN-067": {}, "MN-069": {}, "MN-071": {}, "MN-073": {},
	"MN-1": {}, "MR-01": {}, "MR-02": {}, "MR-03": {}, "MR-04": {},
	"MR-05": {}, "MR-06": {}, "MR-07": {}, "MR-08": {}, "MR-09": {},
	"MR-10": {}, "MR-11": {}, "MR-12": {}, "MR-13": {}, "MR-NKC": {}, "MT-01": {},
	"MT-02": {}, "MT-03": {}, "MT-04": {}, "MT-05": {}, "MT-06": {},
	"MT-07": {}, "MT-08": {}, "MT-09": {}, "MT-10": {}, "MT-11": {},
	"MT-12": {}, "MT-13": {}, "MT-14": {}, "MT-15": {}, "MT-16": {},
	"MT-17": {}, "MT-18": {}, "MT-19": {}, "MT-20": {}, "MT-21": {},
	"MT-22": {}, "MT-23": {}, "MT-24": {}, "MT-25": {}, "MT-26": {},
	"MT-27": {}, "MT-28": {}, "MT-29": {}, "MT-30": {}, "MT-31": {},
	"MT-32": {}, "MT-33": {}, "MT-34": {}, "MT-35": {}, "MT-36": {},
	"MT-37": {}, "MT-38": {}, "MT-39": {}, "MT-40": {}, "MT-41": {},
	"MT-42": {}, "MT-43": {}, "MT-44": {}, "MT-45": {}, "MT-46": {},
	"MT-47": {}, "MT-48": {}, "MT-49": {}, "MT-50": {}, "MT-51": {},
	"MT-52": {}, "MT-53": {}, "MT-54": {}, "MT-55": {}, "MT-56": {},
	"MT-57": {}, "MT-58": {}, "MT-59": {}, "MT-60": {}, "MT-61": {},
	"MT-62": {}, "MT-63": {}, "MT-64": {}, "MT-65": {}, "MT-66": {},
	"MT-67": {}, "MT-68": {}, "MU-AG": {}, "MU-BL": {}, "MU-BR": {},
	"MU-CC": {}, "MU-CU": {}, "MU-FL": {}, "MU-GP": {}, "MU-MO": {},
	"MU-PA": {}, "MU-PL": {}, "MU-PU": {}, "MU-PW": {}, "MU-QB": {},
	"MU-RO": {}, "MU-RP": {}, "MU-RR": {}, "MU-SA": {}, "MU-VP": {}, "MV-00": {},
	"MV-01": {}, "MV-02": {}, "MV-03": {}, "MV-04": {}, "MV-05": {},
	"MV-07": {}, "MV-08": {}, "MV-12": {}, "MV-13": {}, "MV-14": {},
	"MV-17": {}, "MV-20": {}, "MV-23": {}, "MV-24": {}, "MV-25": {},
	"MV-26": {}, "MV-27": {}, "MV-28": {}, "MV-29": {}, "MV-CE": {},
	"MV-MLE": {}, "MV-NC": {}, "MV-NO": {}, "MV-SC": {}, "MV-SU": {},
	"MV-UN": {}, "MV-US": {}, "MW-BA": {}, "MW-BL": {}, "MW-C": {},
	"MW-CK": {}, "MW-CR": {}, "MW-CT": {}, "MW-DE": {}, "MW-DO": {},
	"MW-KR": {}, "MW-KS": {}, "MW-LI": {}, "MW-LK": {}, "MW-MC": {},
	"MW-MG": {}, "MW-MH": {}, "MW-MU": {}, "MW-MW": {}, "MW-MZ": {},
	"MW-N": {}, "MW-NB": {}, "MW-NE": {}, "MW-NI": {}, "MW-NK": {},
	"MW-NS": {}, "MW-NU": {}, "MW-PH": {}, "MW-RU": {}, "MW-S": {},
	"MW-SA": {}, "MW-TH": {}, "MW-ZO": {}, "MX-AGU": {}, "MX-BCN": {},
	"MX-BCS": {}, "MX-CAM": {}, "MX-CHH": {}, "MX-CHP": {}, "MX-COA": {},
	"MX-COL": {}, "MX-CMX": {}, "MX-DIF": {}, "MX-DUR": {}, "MX-GRO": {}, "MX-GUA": {},
	"MX-HID": {}, "MX-JAL": {}, "MX-MEX": {}, "MX-MIC": {}, "MX-MOR": {},
	"MX-NAY": {}, "MX-NLE": {}, "MX-OAX": {}, "MX-PUE": {}, "MX-QUE": {},
	"MX-ROO": {}, "MX-SIN": {}, "MX-SLP": {}, "MX-SON": {}, "MX-TAB": {},
	"MX-TAM": {}, "MX-TLA": {}, "MX-VER": {}, "MX-YUC": {}, "MX-ZAC": {},
	"MY-01": {}, "MY-02": {}, "MY-03": {}, "MY-04": {}, "MY-05": {},
	"MY-06": {}, "MY-07": {}, "MY-08": {}, "MY-09": {}, "MY-10": {},
	"MY-11": {}, "MY-12": {}, "MY-13": {}, "MY-14": {}, "MY-15": {},
	"MY-16": {}, "MZ-A": {}, "MZ-B": {}, "MZ-G": {}, "MZ-I": {},
	"MZ-L": {}, "MZ-MPM": {}, "MZ-N": {}, "MZ-P": {}, "MZ-Q": {},
	"MZ-S": {}, "MZ-T": {}, "NA-CA": {}, "NA-ER": {}, "NA-HA": {},
	"NA-KA": {}, "NA-KE": {}, "NA-KH": {}, "NA-KU": {}, "NA-KW": {}, "NA-OD": {}, "NA-OH": {},
	"NA-OK": {}, "NA-ON": {}, "NA-OS": {}, "NA-OT": {}, "NA-OW": {},
	"NE-1": {}, "NE-2": {}, "NE-3": {}, "NE-4": {}, "NE-5": {},
	"NE-6": {}, "NE-7": {}, "NE-8": {}, "NG-AB": {}, "NG-AD": {},
	"NG-AK": {}, "NG-AN": {}, "NG-BA": {}, "NG-BE": {}, "NG-BO": {},
	"NG-BY": {}, "NG-CR": {}, "NG-DE": {}, "NG-EB": {}, "NG-ED": {},
	"NG-EK": {}, "NG-EN": {}, "NG-FC": {}, "NG-GO": {}, "NG-IM": {},
	"NG-JI": {}, "NG-KD": {}, "NG-KE": {}, "NG-KN": {}, "NG-KO": {},
	"NG-KT": {}, "NG-KW": {}, "NG-LA": {}, "NG-NA": {}, "NG-NI": {},
	"NG-OG": {}, "NG-ON": {}, "NG-OS": {}, "NG-OY": {}, "NG-PL": {},
	"NG-RI": {}, "NG-SO": {}, "NG-TA": {}, "NG-YO": {}, "NG-ZA": {},
	"NI-AN": {}, "NI-AS": {}, "NI-BO": {}, "NI-CA": {}, "NI-CI": {},
	"NI-CO": {}, "NI-ES": {}, "NI-GR": {}, "NI-JI": {}, "NI-LE": {},
	"NI-MD": {}, "NI-MN": {}, "NI-MS": {}, "NI-MT": {}, "NI-NS": {},
	"NI-RI": {}, "NI-SJ": {}, "NL-AW": {}, "NL-BQ1": {}, "NL-BQ2": {},
	"NL-BQ3": {}, "NL-CW": {}, "NL-DR": {}, "NL-FL": {}, "NL-FR": {},
	"NL-GE": {}, "NL-GR": {}, "NL-LI": {}, "NL-NB": {}, "NL-NH": {},
	"NL-OV": {}, "NL-SX": {}, "NL-UT": {}, "NL-ZE": {}, "NL-ZH": {},
	"NO-03": {}, "NO-11": {}, "NO-15": {}, "NO-16": {}, "NO-17": {},
	"NO-18": {}, "NO-21": {}, "NO-30": {}, "NO-34": {}, "NO-38": {},
	"NO-42": {}, "NO-46": {}, "NO-50": {}, "NO-54": {},
	"NO-22": {}, "NP-1": {}, "NP-2": {}, "NP-3": {}, "NP-4": {},
	"NP-5": {}, "NP-BA": {}, "NP-BH": {}, "NP-DH": {}, "NP-GA": {},
	"NP-JA": {}, "NP-KA": {}, "NP-KO": {}, "NP-LU": {}, "NP-MA": {},
	"NP-ME": {}, "NP-NA": {}, "NP-RA": {}, "NP-SA": {}, "NP-SE": {},
	"NR-01": {}, "NR-02": {}, "NR-03": {}, "NR-04": {}, "NR-05": {},
	"NR-06": {}, "NR-07": {}, "NR-08": {}, "NR-09": {}, "NR-10": {},
	"NR-11": {}, "NR-12": {}, "NR-13": {}, "NR-14": {}, "NZ-AUK": {},
	"NZ-BOP": {}, "NZ-CAN": {}, "NZ-CIT": {}, "NZ-GIS": {}, "NZ-HKB": {},
	"NZ-MBH": {}, "NZ-MWT": {}, "NZ-N": {}, "NZ-NSN": {}, "NZ-NTL": {},
	"NZ-OTA": {}, "NZ-S": {}, "NZ-STL": {}, "NZ-TAS": {}, "NZ-TKI": {},
	"NZ-WGN": {}, "NZ-WKO": {}, "NZ-WTC": {}, "OM-BA": {}, "OM-BS": {}, "OM-BU": {}, "OM-BJ": {},
	"OM-DA": {}, "OM-MA": {}, "OM-MU": {}, "OM-SH": {}, "OM-SJ": {}, "OM-SS": {}, "OM-WU": {},
	"OM-ZA": {}, "OM-ZU": {}, "PA-1": {}, "PA-2": {}, "PA-3": {},
	"PA-4": {}, "PA-5": {}, "PA-6": {}, "PA-7": {}, "PA-8": {},
	"PA-9": {}, "PA-EM": {}, "PA-KY": {}, "PA-NB": {}, "PE-AMA": {},
	"PE-ANC": {}, "PE-APU": {}, "PE-ARE": {}, "PE-AYA": {}, "PE-CAJ": {},
	"PE-CAL": {}, "PE-CUS": {}, "PE-HUC": {}, "PE-HUV": {}, "PE-ICA": {},
	"PE-JUN": {}, "PE-LAL": {}, "PE-LAM": {}, "PE-LIM": {}, "PE-LMA": {},
	"PE-LOR": {}, "PE-MDD": {}, "PE-MOQ": {}, "PE-PAS": {}, "PE-PIU": {},
	"PE-PUN": {}, "PE-SAM": {}, "PE-TAC": {}, "PE-TUM": {}, "PE-UCA": {},
	"PG-CPK": {}, "PG-CPM": {}, "PG-EBR": {}, "PG-EHG": {}, "PG-EPW": {},
	"PG-ESW": {}, "PG-GPK": {}, "PG-MBA": {}, "PG-MPL": {}, "PG-MPM": {},
	"PG-MRL": {}, "PG-NCD": {}, "PG-NIK": {}, "PG-NPP": {}, "PG-NSB": {},
	"PG-SAN": {}, "PG-SHM": {}, "PG-WBK": {}, "PG-WHM": {}, "PG-WPD": {},
	"PH-00": {}, "PH-01": {}, "PH-02": {}, "PH-03": {}, "PH-05": {},
	"PH-06": {}, "PH-07": {}, "PH-08": {}, "PH-09": {}, "PH-10": {},
	"PH-11": {}, "PH-12": {}, "PH-13": {}, "PH-14": {}, "PH-15": {},
	"PH-40": {}, "PH-41": {}, "PH-ABR": {}, "PH-AGN": {}, "PH-AGS": {},
	"PH-AKL": {}, "PH-ALB": {}, "PH-ANT": {}, "PH-APA": {}, "PH-AUR": {},
	"PH-BAN": {}, "PH-BAS": {}, "PH-BEN": {}, "PH-BIL": {}, "PH-BOH": {},
	"PH-BTG": {}, "PH-BTN": {}, "PH-BUK": {}, "PH-BUL": {}, "PH-CAG": {},
	"PH-CAM": {}, "PH-CAN": {}, "PH-CAP": {}, "PH-CAS": {}, "PH-CAT": {},
	"PH-CAV": {}, "PH-CEB": {}, "PH-COM": {}, "PH-DAO": {}, "PH-DAS": {},
	"PH-DAV": {}, "PH-DIN": {}, "PH-EAS": {}, "PH-GUI": {}, "PH-IFU": {},
	"PH-ILI": {}, "PH-ILN": {}, "PH-ILS": {}, "PH-ISA": {}, "PH-KAL": {},
	"PH-LAG": {}, "PH-LAN": {}, "PH-LAS": {}, "PH-LEY": {}, "PH-LUN": {},
	"PH-MAD": {}, "PH-MAG": {}, "PH-MAS": {}, "PH-MDC": {}, "PH-MDR": {},
	"PH-MOU": {}, "PH-MSC": {}, "PH-MSR": {}, "PH-NCO": {}, "PH-NEC": {},
	"PH-NER": {}, "PH-NSA": {}, "PH-NUE": {}, "PH-NUV": {}, "PH-PAM": {},
	"PH-PAN": {}, "PH-PLW": {}, "PH-QUE": {}, "PH-QUI": {}, "PH-RIZ": {},
	"PH-ROM": {}, "PH-SAR": {}, "PH-SCO": {}, "PH-SIG": {}, "PH-SLE": {},
	"PH-SLU": {}, "PH-SOR": {}, "PH-SUK": {}, "PH-SUN": {}, "PH-SUR": {},
	"PH-TAR": {}, "PH-TAW": {}, "PH-WSA": {}, "PH-ZAN": {}, "PH-ZAS": {},
	"PH-ZMB": {}, "PH-ZSI": {}, "PK-BA": {}, "PK-GB": {}, "PK-IS": {},
	"PK-JK": {}, "PK-KP": {}, "PK-PB": {}, "PK-SD": {}, "PK-TA": {},
	"PL-02": {}, "PL-04": {}, "PL-06": {}, "PL-08": {}, "PL-10": {},
	"PL-12": {}, "PL-14": {}, "PL-16": {}, "PL-18": {}, "PL-20": {},
	"PL-22": {}, "PL-24": {}, "PL-26": {}, "PL-28": {}, "PL-30": {}, "PL-32": {},
	"PS-BTH": {}, "PS-DEB": {}, "PS-GZA": {}, "PS-HBN": {},
	"PS-JEM": {}, "PS-JEN": {}, "PS-JRH": {}, "PS-KYS": {}, "PS-NBS": {},
	"PS-NGZ": {}, "PS-QQA": {}, "PS-RBH": {}, "PS-RFH": {}, "PS-SLT": {},
	"PS-TBS": {}, "PS-TKM": {}, "PT-01": {}, "PT-02": {}, "PT-03": {},
	"PT-04": {}, "PT-05": {}, "PT-06": {}, "PT-07": {}, "PT-08": {},
	"PT-09": {}, "PT-10": {}, "PT-11": {}, "PT-12": {}, "PT-13": {},
	"PT-14": {}, "PT-15": {}, "PT-16": {}, "PT-17": {}, "PT-18": {},
	"PT-20": {}, "PT-30": {}, "PW-002": {}, "PW-004": {}, "PW-010": {},
	"PW-050": {}, "PW-100": {}, "PW-150": {}, "PW-212": {}, "PW-214": {},
	"PW-218": {}, "PW-222": {}, "PW-224": {}, "PW-226": {}, "PW-227": {},
	"PW-228": {}, "PW-350": {}, "PW-370": {}, "PY-1": {}, "PY-10": {},
	"PY-11": {}, "PY-12": {}, "PY-13": {}, "PY-14": {}, "PY-15": {},
	"PY-16": {}, "PY-19": {}, "PY-2": {}, "PY-3": {}, "PY-4": {},
	"PY-5": {}, "PY-6": {}, "PY-7": {}, "PY-8": {}, "PY-9": {},
	"PY-ASU": {}, "QA-DA": {}, "QA-KH": {}, "QA-MS": {}, "QA-RA": {},
	"QA-US": {}, "QA-WA": {}, "QA-ZA": {}, "RO-AB": {}, "RO-AG": {},
	"RO-AR": {}, "RO-B": {}, "RO-BC": {}, "RO-BH": {}, "RO-BN": {},
	"RO-BR": {}, "RO-BT": {}, "RO-BV": {}, "RO-BZ": {}, "RO-CJ": {},
	"RO-CL": {}, "RO-CS": {}, "RO-CT": {}, "RO-CV": {}, "RO-DB": {},
	"RO-DJ": {}, "RO-GJ": {}, "RO-GL": {}, "RO-GR": {}, "RO-HD": {},
	"RO-HR": {}, "RO-IF": {}, "RO-IL": {}, "RO-IS": {}, "RO-MH": {},
	"RO-MM": {}, "RO-MS": {}, "RO-NT": {}, "RO-OT": {}, "RO-PH": {},
	"RO-SB": {}, "RO-SJ": {}, "RO-SM": {}, "RO-SV": {}, "RO-TL": {},
	"RO-TM": {}, "RO-TR": {}, "RO-VL": {}, "RO-VN": {}, "RO-VS": {},
	"RS-00": {}, "RS-01": {}, "RS-02": {}, "RS-03": {}, "RS-04": {},
	"RS-05": {}, "RS-06": {}, "RS-07": {}, "RS-08": {}, "RS-09": {},
	"RS-10": {}, "RS-11": {}, "RS-12": {}, "RS-13": {}, "RS-14": {},
	"RS-15": {}, "RS-16": {}, "RS-17": {}, "RS-18": {}, "RS-19": {},
	"RS-20": {}, "RS-21": {}, "RS-22": {}, "RS-23": {}, "RS-24": {},
	"RS-25": {}, "RS-26": {}, "RS-27": {}, "RS-28": {}, "RS-29": {},
	"RS-KM": {}, "RS-VO": {}, "RU-AD": {}, "RU-AL": {}, "RU-ALT": {},
	"RU-AMU": {}, "RU-ARK": {}, "RU-AST": {}, "RU-BA": {}, "RU-BEL": {},
	"RU-BRY": {}, "RU-BU": {}, "RU-CE": {}, "RU-CHE": {}, "RU-CHU": {},
	"RU-CU": {}, "RU-DA": {}, "RU-IN": {}, "RU-IRK": {}, "RU-IVA": {},
	"RU-KAM": {}, "RU-KB": {}, "RU-KC": {}, "RU-KDA": {}, "RU-KEM": {},
	"RU-KGD": {}, "RU-KGN": {}, "RU-KHA": {}, "RU-KHM": {}, "RU-KIR": {},
	"RU-KK": {}, "RU-KL": {}, "RU-KLU": {}, "RU-KO": {}, "RU-KOS": {},
	"RU-KR": {}, "RU-KRS": {}, "RU-KYA": {}, "RU-LEN": {}, "RU-LIP": {},
	"RU-MAG": {}, "RU-ME": {}, "RU-MO": {}, "RU-MOS": {}, "RU-MOW": {},
	"RU-MUR": {}, "RU-NEN": {}, "RU-NGR": {}, "RU-NIZ": {}, "RU-NVS": {},
	"RU-OMS": {}, "RU-ORE": {}, "RU-ORL": {}, "RU-PER": {}, "RU-PNZ": {},
	"RU-PRI": {}, "RU-PSK": {}, "RU-ROS": {}, "RU-RYA": {}, "RU-SA": {},
	"RU-SAK": {}, "RU-SAM": {}, "RU-SAR": {}, "RU-SE": {}, "RU-SMO": {},
	"RU-SPE": {}, "RU-STA": {}, "RU-SVE": {}, "RU-TA": {}, "RU-TAM": {},
	"RU-TOM": {}, "RU-TUL": {}, "RU-TVE": {}, "RU-TY": {}, "RU-TYU": {},
	"RU-UD": {}, "RU-ULY": {}, "RU-VGG": {}, "RU-VLA": {}, "RU-VLG": {},
	"RU-VOR": {}, "RU-YAN": {}, "RU-YAR": {}, "RU-YEV": {}, "RU-ZAB": {},
	"RW-01": {}, "RW-02": {}, "RW-03": {}, "RW-04": {}, "RW-05": {},
	"SA-01": {}, "SA-02": {}, "SA-03": {}, "SA-04": {}, "SA-05": {},
	"SA-06": {}, "SA-07": {}, "SA-08": {}, "SA-09": {}, "SA-10": {},
	"SA-11": {}, "SA-12": {}, "SA-14": {}, "SB-CE": {}, "SB-CH": {},
	"SB-CT": {}, "SB-GU": {}, "SB-IS": {}, "SB-MK": {}, "SB-ML": {},
	"SB-RB": {}, "SB-TE": {}, "SB-WE": {}, "SC-01": {}, "SC-02": {},
	"SC-03": {}, "SC-04": {}, "SC-05": {}, "SC-06": {}, "SC-07": {},
	"SC-08": {}, "SC-09": {}, "SC-10": {}, "SC-11": {}, "SC-12": {},
	"SC-13": {}, "SC-14": {}, "SC-15": {}, "SC-16": {}, "SC-17": {},
	"SC-18": {}, "SC-19": {}, "SC-20": {}, "SC-21": {}, "SC-22": {},
	"SC-23": {}, "SC-24": {}, "SC-25": {}, "SD-DC": {}, "SD-DE": {},
	"SD-DN": {}, "SD-DS": {}, "SD-DW": {}, "SD-GD": {}, "SD-GK": {}, "SD-GZ": {},
	"SD-KA": {}, "SD-KH": {}, "SD-KN": {}, "SD-KS": {}, "SD-NB": {},
	"SD-NO": {}, "SD-NR": {}, "SD-NW": {}, "SD-RS": {}, "SD-SI": {},
	"SE-AB": {}, "SE-AC": {}, "SE-BD": {}, "SE-C": {}, "SE-D": {},
	"SE-E": {}, "SE-F": {}, "SE-G": {}, "SE-H": {}, "SE-I": {},
	"SE-K": {}, "SE-M": {}, "SE-N": {}, "SE-O": {}, "SE-S": {},
	"SE-T": {}, "SE-U": {}, "SE-W": {}, "SE-X": {}, "SE-Y": {},
	"SE-Z": {}, "SG-01": {}, "SG-02": {}, "SG-03": {}, "SG-04": {},
	"SG-05": {}, "SH-AC": {}, "SH-HL": {}, "SH-TA": {}, "SI-001": {},
	"SI-002": {}, "SI-003": {}, "SI-004": {}, "SI-005": {}, "SI-006": {},
	"SI-007": {}, "SI-008": {}, "SI-009": {}, "SI-010": {}, "SI-011": {},
	"SI-012": {}, "SI-013": {}, "SI-014": {}, "SI-015": {}, "SI-016": {},
	"SI-017": {}, "SI-018": {}, "SI-019": {}, "SI-020": {}, "SI-021": {},
	"SI-022": {}, "SI-023": {}, "SI-024": {}, "SI-025": {}, "SI-026": {},
	"SI-027": {}, "SI-028": {}, "SI-029": {}, "SI-030": {}, "SI-031": {},
	"SI-032": {}, "SI-033": {}, "SI-034": {}, "SI-035": {}, "SI-036": {},
	"SI-037": {}, "SI-038": {}, "SI-039": {}, "SI-040": {}, "SI-041": {},
	"SI-042": {}, "SI-043": {}, "SI-044": {}, "SI-045": {}, "SI-046": {},
	"SI-047": {}, "SI-048": {}, "SI-049": {}, "SI-050": {}, "SI-051": {},
	"SI-052": {}, "SI-053": {}, "SI-054": {}, "SI-055": {}, "SI-056": {},
	"SI-057": {}, "SI-058": {}, "SI-059": {}, "SI-060": {}, "SI-061": {},
	"SI-062": {}, "SI-063": {}, "SI-064": {}, "SI-065": {}, "SI-066": {},
	"SI-067": {}, "SI-068": {}, "SI-069": {}, "SI-070": {}, "SI-071": {},
	"SI-072": {}, "SI-073": {}, "SI-074": {}, "SI-075": {}, "SI-076": {},
	"SI-077": {}, "SI-078": {}, "SI-079": {}, "SI-080": {}, "SI-081": {},
	"SI-082": {}, "SI-083": {}, "SI-084": {}, "SI-085": {}, "SI-086": {},
	"SI-087": {}, "SI-088": {}, "SI-089": {}, "SI-090": {}, "SI-091": {},
	"SI-092": {}, "SI-093": {}, "SI-094": {}, "SI-095": {}, "SI-096": {},
	"SI-097": {}, "SI-098": {}, "SI-099": {}, "SI-100": {}, "SI-101": {},
	"SI-102": {}, "SI-103": {}, "SI-104": {}, "SI-105": {}, "SI-106": {},
	"SI-107": {}, "SI-108": {}, "SI-109": {}, "SI-110": {}, "SI-111": {},
	"SI-112": {}, "SI-113": {}, "SI-114": {}, "SI-115": {}, "SI-116": {},
	"SI-117": {}, "SI-118": {}, "SI-119": {}, "SI-120": {}, "SI-121": {},
	"SI-122": {}, "SI-123": {}, "SI-124": {}, "SI-125": {}, "SI-126": {},
	"SI-127": {}, "SI-128": {}, "SI-129": {}, "SI-130": {}, "SI-131": {},
	"SI-132": {}, "SI-133": {}, "SI-134": {}, "SI-135": {}, "SI-136": {},
	"SI-137": {}, "SI-138": {}, "SI-139": {}, "SI-140": {}, "SI-141": {},
	"SI-142": {}, "SI-143": {}, "SI-144": {}, "SI-146": {}, "SI-147": {},
	"SI-148": {}, "SI-149": {}, "SI-150": {}, "SI-151": {}, "SI-152": {},
	"SI-153": {}, "SI-154": {}, "SI-155": {}, "SI-156": {}, "SI-157": {},
	"SI-158": {}, "SI-159": {}, "SI-160": {}, "SI-161": {}, "SI-162": {},
	"SI-163": {}, "SI-164": {}, "SI-165": {}, "SI-166": {}, "SI-167": {},
	"SI-168": {}, "SI-169": {}, "SI-170": {}, "SI-171": {}, "SI-172": {},
	"SI-173": {}, "SI-174": {}, "SI-175": {}, "SI-176": {}, "SI-177": {},
	"SI-178": {}, "SI-179": {}, "SI-180": {}, "SI-181": {}, "SI-182": {},
	"SI-183": {}, "SI-184": {}, "SI-185": {}, "SI-186": {}, "SI-187": {},
	"SI-188": {}, "SI-189": {}, "SI-190": {}, "SI-191": {}, "SI-192": {},
	"SI-193": {}, "SI-194": {}, "SI-195": {}, "SI-196": {}, "SI-197": {},
	"SI-198": {}, "SI-199": {}, "SI-200": {}, "SI-201": {}, "SI-202": {},
	"SI-203": {}, "SI-204": {}, "SI-205": {}, "SI-206": {}, "SI-207": {},
	"SI-208": {}, "SI-209": {}, "SI-210": {}, "SI-211": {}, "SI-212": {}, "SI-213": {}, "SK-BC": {},
	"SK-BL": {}, "SK-KI": {}, "SK-NI": {}, "SK-PV": {}, "SK-TA": {},
	"SK-TC": {}, "SK-ZI": {}, "SL-E": {}, "SL-N": {}, "SL-S": {},
	"SL-W": {}, "SM-01": {}, "SM-02": {}, "SM-03": {}, "SM-04": {},
	"SM-05": {}, "SM-06": {}, "SM-07": {}, "SM-08": {}, "SM-09": {},
	"SN-DB": {}, "SN-DK": {}, "SN-FK": {}, "SN-KA": {}, "SN-KD": {},
	"SN-KE": {}, "SN-KL": {}, "SN-LG": {}, "SN-MT": {}, "SN-SE": {},
	"SN-SL": {}, "SN-TC": {}, "SN-TH": {}, "SN-ZG": {}, "SO-AW": {},
	"SO-BK": {}, "SO-BN": {}, "SO-BR": {}, "SO-BY": {}, "SO-GA": {},
	"SO-GE": {}, "SO-HI": {}, "SO-JD": {}, "SO-JH": {}, "SO-MU": {},
	"SO-NU": {}, "SO-SA": {}, "SO-SD": {}, "SO-SH": {}, "SO-SO": {},
	"SO-TO": {}, "SO-WO": {}, "SR-BR": {}, "SR-CM": {}, "SR-CR": {},
	"SR-MA": {}, "SR-NI": {}, "SR-PM": {}, "SR-PR": {}, "SR-SA": {},
	"SR-SI": {}, "SR-WA": {}, "SS-BN": {}, "SS-BW": {}, "SS-EC": {},
	"SS-EE8": {}, "SS-EE": {}, "SS-EW": {}, "SS-JG": {}, "SS-LK": {}, "SS-NU": {},
	"SS-UY": {}, "SS-WR": {}, "ST-01": {}, "ST-P": {}, "ST-S": {}, "SV-AH": {},
	"SV-CA": {}, "SV-CH": {}, "SV-CU": {}, "SV-LI": {}, "SV-MO": {},
	"SV-PA": {}, "SV-SA": {}, "SV-SM": {}, "SV-SO": {}, "SV-SS": {},
	"SV-SV": {}, "SV-UN": {}, "SV-US": {}, "SY-DI": {}, "SY-DR": {},
	"SY-DY": {}, "SY-HA": {}, "SY-HI": {}, "SY-HL": {}, "SY-HM": {},
	"SY-ID": {}, "SY-LA": {}, "SY-QU": {}, "SY-RA": {}, "SY-RD": {},
	"SY-SU": {}, "SY-TA": {}, "SZ-HH": {}, "SZ-LU": {}, "SZ-MA": {},
	"SZ-SH": {}, "TD-BA": {}, "TD-BG": {}, "TD-BO": {}, "TD-CB": {},
	"TD-EN": {}, "TD-GR": {}, "TD-HL": {}, "TD-KA": {}, "TD-LC": {},
	"TD-LO": {}, "TD-LR": {}, "TD-MA": {}, "TD-MC": {}, "TD-ME": {},
	"TD-MO": {}, "TD-ND": {}, "TD-OD": {}, "TD-SA": {}, "TD-SI": {},
	"TD-TA": {}, "TD-TI": {}, "TD-WF": {}, "TG-C": {}, "TG-K": {},
	"TG-M": {}, "TG-P": {}, "TG-S": {}, "TH-10": {}, "TH-11": {},
	"TH-12": {}, "TH-13": {}, "TH-14": {}, "TH-15": {}, "TH-16": {},
	"TH-17": {}, "TH-18": {}, "TH-19": {}, "TH-20": {}, "TH-21": {},
	"TH-22": {}, "TH-23": {}, "TH-24": {}, "TH-25": {}, "TH-26": {},
	"TH-27": {}, "TH-30": {}, "TH-31": {}, "TH-32": {}, "TH-33": {},
	"TH-34": {}, "TH-35": {}, "TH-36": {}, "TH-37": {}, "TH-38": {}, "TH-39": {},
	"TH-40": {}, "TH-41": {}, "TH-42": {}, "TH-43": {}, "TH-44": {},
	"TH-45": {}, "TH-46": {}, "TH-47": {}, "TH-48": {}, "TH-49": {},
	"TH-50": {}, "TH-51": {}, "TH-52": {}, "TH-53": {}, "TH-54": {},
	"TH-55": {}, "TH-56": {}, "TH-57": {}, "TH-58": {}, "TH-60": {},
	"TH-61": {}, "TH-62": {}, "TH-63": {}, "TH-64": {}, "TH-65": {},
	"TH-66": {}, "TH-67": {}, "TH-70": {}, "TH-71": {}, "TH-72": {},
	"TH-73": {}, "TH-74": {}, "TH-75": {}, "TH-76": {}, "TH-77": {},
	"TH-80": {}, "TH-81": {}, "TH-82": {}, "TH-83": {}, "TH-84": {},
	"TH-85": {}, "TH-86": {}, "TH-90": {}, "TH-91": {}, "TH-92": {},
	"TH-93": {}, "TH-94": {}, "TH-95": {}, "TH-96": {}, "TH-S": {},
	"TJ-GB": {}, "TJ-KT": {}, "TJ-SU": {}, "TJ-DU": {}, "TJ-RA": {}, "TL-AL": {}, "TL-AN": {},
	"TL-BA": {}, "TL-BO": {}, "TL-CO": {}, "TL-DI": {}, "TL-ER": {},
	"TL-LA": {}, "TL-LI": {}, "TL-MF": {}, "TL-MT": {}, "TL-OE": {},
	"TL-VI": {}, "TM-A": {}, "TM-B": {}, "TM-D": {}, "TM-L": {},
	"TM-M": {}, "TM-S": {}, "TN-11": {}, "TN-12": {}, "TN-13": {},
	"TN-14": {}, "TN-21": {}, "TN-22": {}, "TN-23": {}, "TN-31": {},
	"TN-32": {}, "TN-33": {}, "TN-34": {}, "TN-41": {}, "TN-42": {},
	"TN-43": {}, "TN-51": {}, "TN-52": {}, "TN-53": {}, "TN-61": {},
	"TN-71": {}, "TN-72": {}, "TN-73": {}, "TN-81": {}, "TN-82": {},
	"TN-83": {}, "TO-01": {}, "TO-02": {}, "TO-03": {}, "TO-04": {},
	"TO-05": {}, "TR-01": {}, "TR-02": {}, "TR-03": {}, "TR-04": {},
	"TR-05": {}, "TR-06": {}, "TR-07": {}, "TR-08": {}, "TR-09": {},
	"TR-10": {}, "TR-11": {}, "TR-12": {}, "TR-13": {}, "TR-14": {},
	"TR-15": {}, "TR-16": {}, "TR-17": {}, "TR-18": {}, "TR-19": {},
	"TR-20": {}, "TR-21": {}, "TR-22": {}, "TR-23": {}, "TR-24": {},
	"TR-25": {}, "TR-26": {}, "TR-27": {}, "TR-28": {}, "TR-29": {},
	"TR-30": {}, "TR-31": {}, "TR-32": {}, "TR-33": {}, "TR-34": {},
	"TR-35": {}, "TR-36": {}, "TR-37": {}, "TR-38": {}, "TR-39": {},
	"TR-40": {}, "TR-41": {}, "TR-42": {}, "TR-43": {}, "TR-44": {},
	"TR-45": {}, "TR-46": {}, "TR-47": {}, "TR-48": {}, "TR-49": {},
	"TR-50": {}, "TR-51": {}, "TR-52": {}, "TR-53": {}, "TR-54": {},
	"TR-55": {}, "TR-56": {}, "TR-57": {}, "TR-58": {}, "TR-59": {},
	"TR-60": {}, "TR-61": {}, "TR-62": {}, "TR-63": {}, "TR-64": {},
	"TR-65": {}, "TR-66": {}, "TR-67": {}, "TR-68": {}, "TR-69": {},
	"TR-70": {}, "TR-71": {}, "TR-72": {}, "TR-73": {}, "TR-74": {},
	"TR-75": {}, "TR-76": {}, "TR-77": {}, "TR-78": {}, "TR-79": {},
	"TR-80": {}, "TR-81": {}, "TT-ARI": {}, "TT-CHA": {}, "TT-CTT": {},
	"TT-DMN": {}, "TT-ETO": {}, "TT-MRC": {}, "TT-TOB": {}, "TT-PED": {}, "TT-POS": {}, "TT-PRT": {},
	"TT-PTF": {}, "TT-RCM": {}, "TT-SFO": {}, "TT-SGE": {}, "TT-SIP": {},
	"TT-SJL": {}, "TT-TUP": {}, "TT-WTO": {}, "TV-FUN": {}, "TV-NIT": {},
	"TV-NKF": {}, "TV-NKL": {}, "TV-NMA": {}, "TV-NMG": {}, "TV-NUI": {},
	"TV-VAI": {}, "TW-CHA": {}, "TW-CYI": {}, "TW-CYQ": {}, "TW-KIN": {}, "TW-HSQ": {},
	"TW-HSZ": {}, "TW-HUA": {}, "TW-LIE": {}, "TW-ILA": {}, "TW-KEE": {}, "TW-KHH": {},
	"TW-KHQ": {}, "TW-MIA": {}, "TW-NAN": {}, "TW-NWT": {}, "TW-PEN": {}, "TW-PIF": {},
	"TW-TAO": {}, "TW-TNN": {}, "TW-TNQ": {}, "TW-TPE": {}, "TW-TPQ": {},
	"TW-TTT": {}, "TW-TXG": {}, "TW-TXQ": {}, "TW-YUN": {}, "TZ-01": {},
	"TZ-02": {}, "TZ-03": {}, "TZ-04": {}, "TZ-05": {}, "TZ-06": {},
	"TZ-07": {}, "TZ-08": {}, "TZ-09": {}, "TZ-10": {}, "TZ-11": {},
	"TZ-12": {}, "TZ-13": {}, "TZ-14": {}, "TZ-15": {}, "TZ-16": {},
	"TZ-17": {}, "TZ-18": {}, "TZ-19": {}, "TZ-20": {}, "TZ-21": {},
	"TZ-22": {}, "TZ-23": {}, "TZ-24": {}, "TZ-25": {}, "TZ-26": {}, "TZ-27": {}, "TZ-28": {}, "TZ-29": {}, "TZ-30": {}, "TZ-31": {},
	"UA-05": {}, "UA-07": {}, "UA-09": {}, "UA-12": {}, "UA-14": {},
	"UA-18": {}, "UA-21": {}, "UA-23": {}, "UA-26": {}, "UA-30": {},
	"UA-32": {}, "UA-35": {}, "UA-40": {}, "UA-43": {}, "UA-46": {},
	"UA-48": {}, "UA-51": {}, "UA-53": {}, "UA-56": {}, "UA-59": {},
	"UA-61": {}, "UA-63": {}, "UA-65": {}, "UA-68": {}, "UA-71": {},
	"UA-74": {}, "UA-77": {}, "UG-101": {}, "UG-102": {}, "UG-103": {},
	"UG-104": {}, "UG-105": {}, "UG-106": {}, "UG-107": {}, "UG-108": {},
	"UG-109": {}, "UG-110": {}, "UG-111": {}, "UG-112": {}, "UG-113": {},
	"UG-114": {}, "UG-115": {}, "UG-116": {}, "UG-201": {}, "UG-202": {},
	"UG-203": {}, "UG-204": {}, "UG-205": {}, "UG-206": {}, "UG-207": {},
	"UG-208": {}, "UG-209": {}, "UG-210": {}, "UG-211": {}, "UG-212": {},
	"UG-213": {}, "UG-214": {}, "UG-215": {}, "UG-216": {}, "UG-217": {},
	"UG-218": {}, "UG-219": {}, "UG-220": {}, "UG-221": {}, "UG-222": {},
	"UG-223": {}, "UG-224": {}, "UG-301": {}, "UG-302": {}, "UG-303": {},
	"UG-304": {}, "UG-305": {}, "UG-306": {}, "UG-307": {}, "UG-308": {},
	"UG-309": {}, "UG-310": {}, "UG-311": {}, "UG-312": {}, "UG-313": {},
	"UG-314": {}, "UG-315": {}, "UG-316": {}, "UG-317": {}, "UG-318": {},
	"UG-319": {}, "UG-320": {}, "UG-321": {}, "UG-401": {}, "UG-402": {},
	"UG-403": {}, "UG-404": {}, "UG-405": {}, "UG-406": {}, "UG-407": {},
	"UG-408": {}, "UG-409": {}, "UG-410": {}, "UG-411": {}, "UG-412": {},
	"UG-413": {}, "UG-414": {}, "UG-415": {}, "UG-416": {}, "UG-417": {},
	"UG-418": {}, "UG-419": {}, "UG-C": {}, "UG-E": {}, "UG-N": {},
	"UG-W": {}, "UG-322": {}, "UG-323": {}, "UG-420": {}, "UG-117": {},
	"UG-118": {}, "UG-225": {}, "UG-120": {}, "UG-226": {},
	"UG-121": {}, "UG-122": {}, "UG-227": {}, "UG-421": {},
	"UG-325": {}, "UG-228": {}, "UG-123": {}, "UG-422": {},
	"UG-326": {}, "UG-229": {}, "UG-124": {}, "UG-423": {},
	"UG-230": {}, "UG-327": {}, "UG-424": {}, "UG-328": {},
	"UG-425": {}, "UG-426": {}, "UG-330": {},
	"UM-67": {}, "UM-71": {}, "UM-76": {}, "UM-79": {},
	"UM-81": {}, "UM-84": {}, "UM-86": {}, "UM-89": {}, "UM-95": {},
	"US-AK": {}, "US-AL": {}, "US-AR": {}, "US-AS": {}, "US-AZ": {},
	"US-CA": {}, "US-CO": {}, "US-CT": {}, "US-DC": {}, "US-DE": {},
	"US-FL": {}, "US-GA": {}, "US-GU": {}, "US-HI": {}, "US-IA": {},
	"US-ID": {}, "US-IL": {}, "US-IN": {}, "US-KS": {}, "US-KY": {},
	"US-LA": {}, "US-MA": {}, "US-MD": {}, "US-ME": {}, "US-MI": {},
	"US-MN": {}, "US-MO": {}, "US-MP": {}, "US-MS": {}, "US-MT": {},
	"US-NC": {}, "US-ND": {}, "US-NE": {}, "US-NH": {}, "US-NJ": {},
	"US-NM": {}, "US-NV": {}, "US-NY": {}, "US-OH": {}, "US-OK": {},
	"US-OR": {}, "US-PA": {}, "US-PR": {}, "US-RI": {}, "US-SC": {},
	"US-SD": {}, "US-TN": {}, "US-TX": {}, "US-UM": {}, "US-UT": {},
	"US-VA": {}, "US-VI": {}, "US-VT": {}, "US-WA": {}, "US-WI": {},
	"US-WV": {}, "US-WY": {}, "UY-AR": {}, "UY-CA": {}, "UY-CL": {},
	"UY-CO": {}, "UY-DU": {}, "UY-FD": {}, "UY-FS": {}, "UY-LA": {},
	"UY-MA": {}, "UY-MO": {}, "UY-PA": {}, "UY-RN": {}, "UY-RO": {},
	"UY-RV": {}, "UY-SA": {}, "UY-SJ": {}, "UY-SO": {}, "UY-TA": {},
	"UY-TT": {}, "UZ-AN": {}, "UZ-BU": {}, "UZ-FA": {}, "UZ-JI": {},
	"UZ-NG": {}, "UZ-NW": {}, "UZ-QA": {}, "UZ-QR": {}, "UZ-SA": {},
	"UZ-SI": {}, "UZ-SU": {}, "UZ-TK": {}, "UZ-TO": {}, "UZ-XO": {},
	"VC-01": {}, "VC-02": {}, "VC-03": {}, "VC-04": {}, "VC-05": {},
	"VC-06": {}, "VE-A": {}, "VE-B": {}, "VE-C": {}, "VE-D": {},
	"VE-E": {}, "VE-F": {}, "VE-G": {}, "VE-H": {}, "VE-I": {},
	"VE-J": {}, "VE-K": {}, "VE-L": {}, "VE-M": {}, "VE-N": {},
	"VE-O": {}, "VE-P": {}, "VE-R": {}, "VE-S": {}, "VE-T": {},
	"VE-U": {}, "VE-V": {}, "VE-W": {}, "VE-X": {}, "VE-Y": {},
	"VE-Z": {}, "VN-01": {}, "VN-02": {}, "VN-03": {}, "VN-04": {},
	"VN-05": {}, "VN-06": {}, "VN-07": {}, "VN-09": {}, "VN-13": {},
	"VN-14": {}, "VN-15": {}, "VN-18": {}, "VN-20": {}, "VN-21": {},
	"VN-22": {}, "VN-23": {}, "VN-24": {}, "VN-25": {}, "VN-26": {},
	"VN-27": {}, "VN-28": {}, "VN-29": {}, "VN-30": {}, "VN-31": {},
	"VN-32": {}, "VN-33": {}, "VN-34": {}, "VN-35": {}, "VN-36": {},
	"VN-37": {}, "VN-39": {}, "VN-40": {}, "VN-41": {}, "VN-43": {},
	"VN-44": {}, "VN-45": {}, "VN-46": {}, "VN-47": {}, "VN-49": {},
	"VN-50": {}, "VN-51": {}, "VN-52": {}, "VN-53": {}, "VN-54": {},
	"VN-55": {}, "VN-56": {}, "VN-57": {}, "VN-58": {}, "VN-59": {},
	"VN-61": {}, "VN-63": {}, "VN-66": {}, "VN-67": {}, "VN-68": {},
	"VN-69": {}, "VN-70": {}, "VN-71": {}, "VN-72": {}, "VN-73": {},
	"VN-CT": {}, "VN-DN": {}, "VN-HN": {}, "VN-HP": {}, "VN-SG": {},
	"VU-MAP": {}, "VU-PAM": {}, "VU-SAM": {}, "VU-SEE": {}, "VU-TAE": {},
	"VU-TOB": {}, "WF-SG": {}, "WF-UV": {}, "WS-AA": {}, "WS-AL": {}, "WS-AT": {}, "WS-FA": {},
	"WS-GE": {}, "WS-GI": {}, "WS-PA": {}, "WS-SA": {}, "WS-TU": {},
	"WS-VF": {}, "WS-VS": {}, "YE-AB": {}, "YE-AD": {}, "YE-AM": {},
	"YE-BA": {}, "YE-DA": {}, "YE-DH": {}, "YE-HD": {}, "YE-HJ": {}, "YE-HU": {},
	"YE-IB": {}, "YE-JA": {}, "YE-LA": {}, "YE-MA": {}, "YE-MR": {},
	"YE-MU": {}, "YE-MW": {}, "YE-RA": {}, "YE-SA": {}, "YE-SD": {}, "YE-SH": {},
	"YE-SN": {}, "YE-TA": {}, "ZA-EC": {}, "ZA-FS": {}, "ZA-GP": {},
	"ZA-LP": {}, "ZA-MP": {}, "ZA-NC": {}, "ZA-NW": {}, "ZA-WC": {},
	"ZA-ZN": {}, "ZA-KZN": {}, "ZM-01": {}, "ZM-02": {}, "ZM-03": {}, "ZM-04": {},
	"ZM-05": {}, "ZM-06": {}, "ZM-07": {}, "ZM-08": {}, "ZM-09": {}, "ZM-10": {},
	"ZW-BU": {}, "ZW-HA": {}, "ZW-MA": {}, "ZW-MC": {}, "ZW-ME": {},
	"ZW-MI": {}, "ZW-MN": {}, "ZW-MS": {}, "ZW-MV": {}, "ZW-MW": {},
}
