% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generics.R, R/assay.R, R/assay5.R, R/seurat.R
\name{LayerData}
\alias{LayerData}
\alias{LayerData<-}
\alias{Layers}
\alias{LayerData.Assay}
\alias{LayerData<-.Assay}
\alias{Layers.Assay}
\alias{LayerData.Assay5}
\alias{LayerData<-.Assay5}
\alias{Layers.Assay5}
\alias{LayerData.Seurat}
\alias{LayerData<-.Seurat}
\alias{Layers.Seurat}
\title{Query and Manipulate Assay Layers}
\usage{
LayerData(object, layer, ...)

LayerData(object, layer, ...) <- value

Layers(object, ...)

\method{LayerData}{Assay}(
  object,
  layer = NULL,
  cells = NULL,
  features = NULL,
  slot = deprecated(),
  ...
)

\method{LayerData}{Assay}(object, layer, ...) <- value

\method{Layers}{Assay}(object, search = NA, ...)

\method{LayerData}{Assay5}(
  object,
  layer = NULL,
  cells = NULL,
  features = NULL,
  fast = FALSE,
  slot = deprecated(),
  ...
)

\method{LayerData}{Assay5}(object, layer, features = NULL, cells = NULL, ...) <- value

\method{Layers}{Assay5}(object, search = NA, ...)

\method{LayerData}{Seurat}(object, layer = NULL, assay = NULL, slot = deprecated(), ...)

\method{LayerData}{Seurat}(object, layer, assay = NULL, ...) <- value

\method{Layers}{Seurat}(object, search = NA, assay = NULL, ...)
}
\arguments{
\item{object}{An object}

\item{layer}{Name of layer to fetch or set}

\item{...}{Arguments passed to other methods}

\item{value}{New two-dimensional data to be added as a layer}

\item{features, cells}{Vectors of features/cells to include}

\item{slot}{\Sexpr[stage=build,results=rd]{lifecycle::badge("deprecated")}}

\item{search}{A pattern to search layer names for; pass one of:
\itemize{
 \item \dQuote{\code{NA}} to pull all layers
 \item \dQuote{\code{NULL}} to pull the default layer(s)
 \item a \link[base:grep]{regular expression} that matches layer names
}}

\item{fast}{Determine how to return the layer data; choose from:
\describe{
 \item{\code{FALSE}}{Apply any transpositions and attempt to add
  feature/cell names (if supported) back to the layer data}
 \item{\code{NA}}{Attempt to add feature/cell names back to the layer data,
  skip any transpositions}
 \item{\code{TRUE}}{Do not apply any transpositions or add feature/cell
  names to the layer data}
}}

\item{assay}{Name of assay to fetch layer data from or assign layer data to}
}
\value{
\code{LayerData}: the layer data for \code{layer} from \code{object}

\code{Layer<-}: \code{object} with \code{value} added as a layer
named \code{layer}

\code{Layers}: the names of the layers present in \code{object}
}
\description{
Query and Manipulate Assay Layers
}
\concept{data-access}
