% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/s2-point.R
\name{s2_point}
\alias{s2_point}
\alias{s2_point_crs}
\alias{as_s2_point}
\alias{as_s2_point.default}
\alias{as_s2_point.wk_xy}
\alias{as_s2_point.wk_xyz}
\title{Create an S2 Point Vector}
\usage{
s2_point(x, y, z)

s2_point_crs()

as_s2_point(x, ...)

\method{as_s2_point}{default}(x, ...)

\method{as_s2_point}{wk_xy}(x, ...)

\method{as_s2_point}{wk_xyz}(x, ...)
}
\arguments{
\item{x, y, z}{Vectors of latitude and longitude values in degrees.}

\item{...}{Unused}
}
\value{
An object with class s2_point
}
\description{
In S2 terminology, a "point" is a 3-dimensional unit vector representation
of an \code{\link[=s2_point]{s2_point()}}. Internally, all s2 objects are stored as
3-dimensional unit vectors.
}
\examples{
point <- s2_lnglat(-64, 45) # Halifax, Nova Scotia!
as_s2_point(point)
as.data.frame(as_s2_point(point))

}
