# JSXGraph - Graphics with JavaScript

**Contributors:** Matthias Ehmann, Michael Gerhäuser, Carsten Miller, Bianca Valentin, Alfred Wassermann, Peter Wilfahrt

**Tags:** jsxgraph, geometry, plotting, visualization, javascript, svg, vml, rendering, graphics

- Requires at least: 2.2
- Tested up to: 2.8.4
- Stable tag: 1.00.0

Using the JSXGraph filter makes it a lot easier to embed JSXGraph constructions into wordpress pages/posts.

### Description

[JSXGraph](http://www.jsxgraph.org/) is a cross-browser library for interactive geometry, function plotting, graphs, and data visualization in a web browser. It is implemented completely in JavaScript and uses SVG and VML.
JSXGraph is easy to embed and has a small footprint: only about 80 KB if embedded in a web page. No plug-ins are required!
[JSXGraph](http://www.jsxgraph.org/) is developed at the [Lehrstuhl für Mathematik und ihre Didaktik](http://did.mat.uni-bayreuth.de/), [University of Bayreuth](http://www.uni-bayreuth.de/), Germany.


### Installation

*Caution:*
The current version has to be regarded as a development version. Use with caution!

*Installation:* (by Admin)

1. Upload the complete folder "jsxgraph" into your blogs plugins folder (wp-content/plugins)
2. Navigate to the admin panel, there to your plugins and activate the JSXGraph plugin
optional:
3. Remove the javascript-files in the plugins-folder in order to load the current version
   from the jsxgraph-website (same for the stylesheet).

*Usage:*

1. Open a a blog post or new page and
2. Write your desired content. At the position the construction should appear, create a construction by:
	* switching to the code input
	* inserting a `<jsxgraph>`-tag with all required parameters
	* NOTE: you do have to surround the `<jsxgraph>`-tag with `<pre><jsxgraph ...></pre>`

Be aware of the fact, that you dont't see the construction unless you leave the editor and save your document.

### Screenshots

1. Hypotrochoid `/tags/0.2.5/screenshot-1.jpg`
2. Angles `/tags/0.2.5/screenshot-2.jpg`
3. Importing GEONExT and Intergeo files `/tags/0.2.5/screenshot-3.jpg`
4. Chart `/tags/0.2.5/screenshot-4.jpg`
5. Function plot with derivative and integral `/tags/0.2.5/screenshot-5.jpg`
6. Data plot and analysis `/tags/0.2.5/screenshot-6.jpg`


### Examples

You do find a large compilation of showcases and examples at the [JSXGraph Examples](http://jsxgraph.uni-bayreuth.de/wp/examples/)-Section.

### Frequently Asked Questions

You find questions and answers in the related Google group:
[JSXGraph Google Group](http://groups.google.com/group/jsxgraph)
