#!/usr/bin/env perl

BEGIN {
   die "The PERCONA_TOOLKIT_BRANCH environment variable is not set.\n"
      unless $ENV{PERCONA_TOOLKIT_BRANCH} && -d $ENV{PERCONA_TOOLKIT_BRANCH};
   unshift @INC, "$ENV{PERCONA_TOOLKIT_BRANCH}/lib";
};

use strict;
use warnings FATAL => 'all';
use English qw(-no_match_vars);
use Test::More;

use Sandbox;
use PerconaTest;

require "$trunk/bin/pt-query-digest";
require VersionParser;

my $dp  = new DSNParser(opts=>$dsn_opts);
my $sb  = new Sandbox(basedir => '/tmp', DSNParser => $dp);
my $dbh = $sb->get_dbh_for('source');

if ( !$dbh ) {
   plan skip_all => 'Cannot connect to sandbox source';
}

$dbh->do('drop database if exists food');
$dbh->do('create database food');
$dbh->do('use food');
$dbh->do('create table trees (fruit varchar(24), unique index (fruit))');

my $output = '';
my @args   = ('--explain', 'h=127.1,P=12345,u=msandbox,p=msandbox,D=food', qw(--report-format=query_report --limit 10));

# The table has no rows so EXPLAIN will return NULL for most values.
ok(
   no_diff(
      sub { pt_query_digest::main(@args,
         "$trunk/t/lib/samples/slowlogs/slow007.txt") },
      ( $sandbox_version ge '8.0' ? "t/pt-query-digest/samples/slow007_explain_1-80.txt"
      : $sandbox_version ge '5.7' ? "t/pt-query-digest/samples/slow007_explain_1-57.txt"
      : $sandbox_version ge '5.5' ? "t/pt-query-digest/samples/slow007_explain_1-55.txt"
      : $sandbox_version ge '5.1' ? "t/pt-query-digest/samples/slow007_explain_1-51.txt"
      :                             "t/pt-query-digest/samples/slow007_explain_1.txt"),
   ),
   'Analysis for slow007 with --explain, no rows',
);

# output=json

SKIP: {
   skip "output=json tests require 5.7" unless $sandbox_version ge '5.7';
   my $jq = `which jq`;
   chomp $jq;
   skip "output=json tests require jq" unless -x "$jq";

   ok(
      no_diff(
         sub { pt_query_digest::main(@args, '--output=json',
            "$trunk/t/lib/samples/slowlogs/slow007.txt") },
         ( $sandbox_version ge '8.0' ? "t/pt-query-digest/samples/slow007_explain_json_1-80.txt"
         : "t/pt-query-digest/samples/slow007_explain_json_1-57.txt"),
         post_pipe => 'jq -S .',
         sed => [ q/'s!"name": ".*slow007.txt"!"name": "slow007.txt"!'/ ],
      ),
      'Analysis for slow007 with --explain and --output=json, no rows',
   );
}

# Normalish output from EXPLAIN.
$dbh->do("insert into trees values ('apple'),('orange'),('banana')");

ok(
   no_diff(
      sub { pt_query_digest::main(@args,
         "$trunk/t/lib/samples/slowlogs/slow007.txt") },
      ( $sandbox_version ge '8.0' ? "t/pt-query-digest/samples/slow007_explain_2-80.txt"
      : $sandbox_version ge '5.7' ? "t/pt-query-digest/samples/slow007_explain_2-57.txt"
      : $sandbox_version ge '5.1' ? "t/pt-query-digest/samples/slow007_explain_2-51.txt"
                                  : "t/pt-query-digest/samples/slow007_explain_2.txt"),
   ),
   'Analysis for slow007 with --explain',
);

# output=json

SKIP: {
   skip "output=json tests require 5.7" unless $sandbox_version ge '5.7';
   my $jq = `which jq`;
   chomp $jq;
   skip "output=json tests require jq" unless -x "$jq";

   ok(
      no_diff(
         sub { pt_query_digest::main(@args, '--output=json',
            "$trunk/t/lib/samples/slowlogs/slow007.txt") },
         ( $sandbox_version ge '8.0' ? "t/pt-query-digest/samples/slow007_explain_json_2-80.txt"
         : "t/pt-query-digest/samples/slow007_explain_json_2-57.txt"),
         post_pipe => 'jq -S .',
         sed => [ q/'s!"name": ".*slow007.txt"!"name": "slow007.txt"!'/ ],
      ),
      'Analysis for slow007 with --explain and --output=json',
   );
}

# #############################################################################
# Issue 1141: Add "spark charts" to mk-query-digest profile
# #############################################################################
ok(
   no_diff(
      sub { pt_query_digest::main(@args,
         "$trunk/t/lib/samples/slowlogs/slow007.txt", qw(--report-format profile)) },
      "t/pt-query-digest/samples/slow007_explain_4.txt",
   ),
   'EXPLAIN sparkline in profile'
);

# #############################################################################
# Failed EXPLAIN.
# #############################################################################
$dbh->do('drop table trees');

ok(
   no_diff(
      sub { pt_query_digest::main(@args,
         '--report-format', 'query_report,profile',
         "$trunk/t/lib/samples/slowlogs/slow007.txt") },
      "t/pt-query-digest/samples/slow007_explain_3.txt",
      trf => "sed 's/at .* line [0-9]*/at line ?/'",
   ),
   'Analysis for slow007 with --explain, failed',
);

# #############################################################################
# Issue 1196: mk-query-digest --explain is broken
# #############################################################################
$sb->load_file('source', "t/pt-query-digest/samples/issue_1196.sql");

ok(
   no_diff(
      sub { pt_query_digest::main(@args,
         '--report-format', 'profile,query_report',
         "$trunk/t/pt-query-digest/samples/issue_1196.log",)
      },
      (  $sandbox_version ge '8.0' ? "t/pt-query-digest/samples/issue_1196-output-8.0.txt"
       : $sandbox_version ge '5.7' ? "t/pt-query-digest/samples/issue_1196-output-5.7.txt"
       : $sandbox_version ge '5.6' ? "t/pt-query-digest/samples/issue_1196-output-5.6.txt"
       : $sandbox_version ge '5.1' ? "t/pt-query-digest/samples/issue_1196-output.txt"
       :                             "t/pt-query-digest/samples/issue_1196-output-5.0.txt"),
      keep_output => 1,
   ),
   "--explain sparkline uses event db and doesn't crash ea (issue 1196)"
) or diag(`cat /tmp/percona-toolkit-test-output.txt`);
diag(`rm /tmp/percona-toolkit-test-output.txt`);

# #############################################################################
# Done.
# #############################################################################
$sb->wipe_clean($dbh);
ok($sb->ok(), "Sandbox servers") or BAIL_OUT(__FILE__ . " broke the sandbox");
done_testing;
