--TEST--
swoole_coroutine_scheduler/preemptive: do-while
--SKIPIF--
<?php
require __DIR__ . '/../../include/skipif.inc';
?>
--FILE--
<?php declare(strict_types = 1);
require __DIR__ . '/../../include/bootstrap.php';

co::set(['enable_preemptive_scheduler' => true]);

Co::run(function() {
    $maxspan = 60;
    $start = microtime(true);
    echo "start\n";
    $flag = 1;
    go(function () use (&$flag) {
        echo "coro 1 start to loop\n";
        $i = 0;
        while ($flag) {
            $i++;
        }
        echo "coro 1 can exit\n";
    });
    $end = microtime(true);
    $timespan = ($end - $start) * 1000;
    USE_VALGRIND || Assert::lessThanEq($timespan, $maxspan);
    go(function () use (&$flag) {
        echo "coro 2 set flag = false\n";
        $flag = false;
    });
    usleep(1000);
    echo "end\n";
});
?>
--EXPECTF--
start
coro 1 start to loop
coro 2 set flag = false
coro 1 can exit
end
